<%@ page contentType="text/html; charset=utf-8" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>
<%@ page import="jp.yoyoyoyo.webform.form.EntryForm" %>
<html>
<head>
	<title>ユーザ情報登録（入力）</title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<link rel="stylesheet" type="text/css" href="<html:rewrite page='/view/css/webform.css'/>" />

<script type="text/javascript" >
    function load_address() {
        var url = "/WebForm/Postal.do?c=" + document.getElementsByName("zip1").item(0).value + document.getElementsByName("zip2").item(0).value;
        childWin = window.open(url, 'childWindowPostal', 'width=600,height=200,status=no,scrollbars=yes,directories=no,menubar=no,resizable=no,left=300,top=50');
    }

    function searchAddress() {
        document.getElementsByName("address1").item(0).value = childWin.document.getElementsByName("postalAddress1").item(0).value;
        document.getElementsByName("address2").item(0).value = childWin.document.getElementsByName("postalAddress2").item(0).value;
        document.getElementsByName("address3").item(0).value = childWin.document.getElementsByName("postalAddress3").item(0).value;
         
        childWin.close();
    }
    
    function convHiraganaToKatakana(input) {
        var output = '';
        var c;
        var n;
        for (var i = 0; i < input.length; i++) {
            c = document.getElementsByName(input).item(0).value.charAt(i);
            n = c.charCodeAt(0);
            if ((n >= 0x3041) && (n <= 0x3096)) {
                c = String.fromCharCode(n + 0x60);
            }
            output += c;
        }
        document.getElementsByName(input).item(0).value = output;
    }
</script>

</head>
<body>
<jsp:include page="/view/header.jsp" />
<font color="#FF0000">
<html:errors />
</font>
<html:form action="/Entry">
<table>
	<tr>
		<th>お名前</th>
            <td>
                <table>
                    <tr>
                        <td>姓（漢字）</td>
                        <td><html:text property="seiKanji" maxlength="20" value="${seiKanji}" /></td>
                        <td>名（漢字）</td>
                        <td><html:text property="meiKanji" maxlength="20" value="${meiKanji}" /></td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <th>カナ氏名</th>
            <td>
                <table>
                    <tr>
                        <td>姓（カナ）</td>
                        <td><html:text property="seiKana" maxlength="20" value="${seiKana}" onblur = "convHiraganaToKatakana('seiKana')"/></td>
                        <td>名（カナ）</td>
                        <td><html:text property="meiKana" maxlength="20" value="${meiKana}" onblur = "convHiraganaToKatakana('meiKana')"/></td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <th>生年月日</th>
            <td>
            		<html:text property="birthDate" maxlength="8" value="${birthDate}"  /><br/>
            		※YYYYMMDD形式で入力してください
                	
            </td>
        </tr>
        <tr>
            <th>性別</th>
            <td>
            	<% 
            		EntryForm entryForm = (EntryForm)session.getAttribute("entryData");
            		String gender = "";
            		if(entryForm != null){
            			gender = String.valueOf(entryForm.getGender());
            		}
            	%>
            	<% if(gender == null || gender.equals("")){ %>
           			<input type="radio" name="gender" value="1" />男
           			<input type="radio" name="gender" value="2" />女
	           	<% } else if(gender.equals("1")){ %>
           			<input type="radio" name="gender" value="1" checked="checked"/>男
           			<input type="radio" name="gender" value="2" />女
            	<% } else if(gender.equals("2")){ %>
           			<input type="radio" name="gender" value="1" />男
           			<input type="radio" name="gender" value="2" checked="checked" />女
            	<% } %>
            </td>
        </tr>
        <tr>
            <th>住所</th>
            <td>
                <table>
                    <tr>
                        <td>郵便番号</td>
                        <td><html:text property="zip1" maxlength="3" value="${zip1}"/>-<html:text property="zip2" maxlength="4" value="${zip2}"/></td>
                        <td><input type="button" value="郵便番号から住所を選択する" onclick="load_address(); return false;"/></td>
                    </tr>
                </table>
                <table>
                    <tr>
                        <td>都道府県</td>
                        <td><html:text property="address1" maxlength="30" value="${address1}" /></td>
                    </tr>
                    <tr>    
                        <td>市区郡</td>
                        <td><html:text property="address2" maxlength="30" value="${address2}" /></td>
                    </tr>
                    <tr>
                        <td>町名・番地</td>
                        <td><html:text property="address3" maxlength="40" value="${address3}" /></td>
                    </tr>
                    <tr>
                        <td>アパート・マンション名</td>
                        <td><html:text property="address4" maxlength="40" value="${address4}" /></td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <th>電話番号</th>
            <td>
                <table>
                   <tr>
                        <td colspan="2">
                        どちらか片方入力してください
                        </td>
                    </tr>
                    <tr>
                        <td>自宅電話番号</td>
                        <td><html:text property="tel1" maxlength="10" value="${tel1}"/>-<html:text property="tel2" maxlength="10" value="${tel2}" />-<html:text property="tel3" maxlength="10" value="${tel3}" /></td>
                    </tr>
                    <tr>
                        <td>携帯電話番号</td>
                        <td><html:text property="mTel1" maxlength="10" value="${mTel1}" />-<html:text property="mTel2" maxlength="10" value="${mTel2}" />-<html:text property="mTel3" maxlength="10" value="${mTel3}" /></td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <th>メールアドレス</th>
            <td><html:text property="email1" maxlength="50" value="${email1}" />
                <br />
                ※確認のため、もう一度ご入力ください<br />
               <html:text property="email2" maxlength="50" value="${email2}" />             
            </td>
        </tr>
        <tr>
            <th>職業</th>
            <td>
				<html:select property="occupation" value="${occupation}" >
					<html:option value="">選択してください</html:option>
					<html:option value="1">会社員</html:option>
					<html:option value="2">公務員</html:option>
					<html:option value="3">会社役員</html:option>
					<html:option value="4">自営業</html:option>
					<html:option value="5">農林水産業</html:option>
					<html:option value="6">自由業</html:option>
					<html:option value="7">パートタイマー</html:option>
					<html:option value="8">主婦</html:option>
					<html:option value="9">その他</html:option>
					<html:option value="10">無職</html:option>
				</html:select>
			</td>
        </tr>
</table>
<br />

	<html:submit property="next" value="次へ" />
</html:form>
<jsp:include page="/view/footer.jsp" />
</body>
</html>
