package jp.yoyoyoyo.webform.action;


import java.io.FileInputStream;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class PostalAction extends Action  {

	public ActionForward execute(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response){
			
		// Getp[^̎擾
		String postalCode = request.getParameter("c");

		ServletContext context = getServlet().getServletContext();
		String path = context.getRealPath("/view/postal.xml");
		
		// XMLYX֔ԍ̏Z擾鏈
		SAXParserFactory spf = SAXParserFactory.newInstance();
		try{
			SAXParser parser = spf.newSAXParser();
			
			PostalHandler ph = new PostalHandler();
			
			ph.postalCode = postalCode;
			
			parser.parse(new FileInputStream(path),ph);

			request.setAttribute("postalAddress1", ph.result1);
			request.setAttribute("postalAddress2", ph.result2);
			request.setAttribute("postalAddress3", ph.result3);
			
		} catch (Exception e){
			// G[Ƃ͋󕶎Zbg
			request.setAttribute("postalAddress1", "");
			request.setAttribute("postalAddress2", "");
			request.setAttribute("postalAddress3", "");
			
		}

		
		return mapping.findForward("postal");	
	}
}

class PostalHandler extends DefaultHandler{

	public String postalCode = "";
		
	public String result1 = "";
	public String result2 = "";
	public String result3 = "";

	private boolean pFlag = false;
	private boolean aFlag = false;
	private boolean a1Flag = false;
	private boolean a2Flag = false;
	private boolean a3Flag = false;
	
	public void startDocument() {
		
	}

	public void endDocument() {
		
	}

	public void startElement(String namespaceURI,
                               String localName,
                               String qName,
                               Attributes atts) {

        if(qName=="postalcode"){
        	pFlag = true;
        }else if (qName == "address1"){
        	a1Flag = true;
        }else if (qName == "address2"){
        	a2Flag = true;
        }else if (qName == "address3"){
        	a3Flag = true;
        }
	}

    public void endElement(String namespaceURI,
                             String localName,
                             String qName) {
        if(qName=="postalcode"){
        	pFlag = false;
        }else if (qName == "address1"){
        	a1Flag = false;
        }else if (qName == "address2"){
        	a2Flag = false;
        }else if (qName == "address3"){
        	a3Flag = false;
        }
    }

    public void characters(char[] ch, int start, int length) {
    	String text = new String(ch,start,length);
    	if(pFlag == true && postalCode.equals(text)){
      		aFlag = true;
    	}
    	if(aFlag == true && a1Flag == true){
    		this.result1 = text;
    	}
    	if(aFlag == true && a2Flag == true){
    		this.result2 = text;
    	}    	
    	if(aFlag == true && a3Flag == true){
    		this.result3 = text;
    		aFlag = false;
    	} 	
    }

}
