package jp.yoyoyoyo.webform.dto;

import javax.sql.DataSource;

import jp.yoyoyoyo.webform.util.SettingUtil;

import org.apache.tomcat.dbcp.dbcp.BasicDataSource;

public class DaoUtil {
	private DataSource source;
	
	private static DaoUtil inst = new DaoUtil();
	
	private static final String JDBC_URL = "jdbc.driver.url";
	private static final String JDBC_USER = "jdbc.driver.user";
	private static final String JDBC_PASS = "jdbc.driver.pass";
	private static final String JDBC_DRIVER = "jdbc.driver.classname";
	
	private DaoUtil(){
		source = createDataSource();
	}
	
	public static DataSource getSource(){
		return inst.source;
	}
	
	private DataSource createDataSource(){
		BasicDataSource bds = new BasicDataSource();
		
		bds.setDriverClassName(SettingUtil.getProperty(JDBC_DRIVER));
		bds.setUsername(SettingUtil.getProperty(JDBC_USER));
		bds.setPassword(SettingUtil.getProperty(JDBC_PASS));
		bds.setUrl(SettingUtil.getProperty(JDBC_URL));
	
		return bds;
	}
}
