package jp.yoyoyoyo.webform.form;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import jp.yoyoyoyo.webform.util.CommonUtil;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class EntryForm extends ActionForm {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	
	private String seiKanji;
	
	private String meiKanji;
	
	private String seiKana;
	
	private String meiKana;

	private String birthDate;
	
	private int gender;
	
	private String zip1;
	
	private String zip2;
	
	private String address1;
	
	private String address2;
	
	private String address3;
	
	private String address4;
	
	private String tel1;
	
	private String tel2;
	
	private String tel3;
	
	private String mTel1;
	
	private String mTel2;
	
	private String mTel3;
	
	private String email1;
	
	private String email2;
	
	private int occupation;
	
	private String ipAddress;
	
	private String sessionId;
	
	private String tel;
	
	private String mTel;
	
	private String genderText;
	
	private String occupationText;
	
	private String next;


	public String getNext() {
		return next;
	}


	public void setNext(String next) {
		this.next = next;
	}


	public String getSeiKanji() {
		return seiKanji;
	}


	public void setSeiKanji(String seiKanji) {
		this.seiKanji = seiKanji;
	}


	public String getMeiKanji() {
		return meiKanji;
	}


	public void setMeiKanji(String meiKanji) {
		this.meiKanji = meiKanji;
	}


	public String getSeiKana() {
		return seiKana;
	}


	public void setSeiKana(String seiKana) {
		this.seiKana = seiKana;
	}


	public String getMeiKana() {
		return meiKana;
	}


	public void setMeiKana(String meiKana) {
		this.meiKana = meiKana;
	}


	public String getBirthDate() {
		return birthDate;
	}


	public void setBirthDate(String birthDate) {
		this.birthDate = birthDate;
	}


	public int getGender() {
		return gender;
	}


	public void setGender(int gender) {
		this.gender = gender;
	}


	public String getZip1() {
		return zip1;
	}


	public void setZip1(String zip1) {
		this.zip1 = zip1;
	}


	public String getZip2() {
		return zip2;
	}


	public void setZip2(String zip2) {
		this.zip2 = zip2;
	}


	public String getAddress1() {
		return address1;
	}


	public void setAddress1(String address1) {
		this.address1 = address1;
	}


	public String getAddress2() {
		return address2;
	}


	public void setAddress2(String address2) {
		this.address2 = address2;
	}


	public String getAddress3() {
		return address3;
	}


	public void setAddress3(String address3) {
		this.address3 = address3;
	}


	public String getAddress4() {
		return address4;
	}


	public void setAddress4(String address4) {
		this.address4 = address4;
	}


	public String getTel1() {
		return tel1;
	}


	public void setTel1(String tel1) {
		this.tel1 = tel1;
	}


	public String getTel2() {
		return tel2;
	}


	public void setTel2(String tel2) {
		this.tel2 = tel2;
	}


	public String getTel3() {
		return tel3;
	}


	public void setTel3(String tel3) {
		this.tel3 = tel3;
	}


	public String getmTel1() {
		return mTel1;
	}


	public void setmTel1(String mTel1) {
		this.mTel1 = mTel1;
	}


	public String getmTel2() {
		return mTel2;
	}


	public void setmTel2(String mTel2) {
		this.mTel2 = mTel2;
	}


	public String getmTel3() {
		return mTel3;
	}


	public void setmTel3(String mTel3) {
		this.mTel3 = mTel3;
	}


	public String getEmail1() {
		return email1;
	}


	public void setEmail1(String email1) {
		this.email1 = email1;
	}


	public String getEmail2() {
		return email2;
	}


	public void setEmail2(String email2) {
		this.email2 = email2;
	}


	public int getOccupation() {
		return occupation;
	}


	public void setOccupation(int occupation) {
		this.occupation = occupation;
	}


	public String getIpAddress() {
		return ipAddress;
	}


	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}


	public String getSessionId() {
		return sessionId;
	}


	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}


	public String getTel() {
		return tel;
	}


	public void setTel(String tel) {
		this.tel = tel;
	}


	public String getmTel() {
		return mTel;
	}


	public void setmTel(String mTel) {
		this.mTel = mTel;
	}
	
	public String getGenderText() {
		return genderText;
	}


	public void setGenderText(String genderText) {
		this.genderText = genderText;
	}

	public String getOccupationText() {
		return occupationText;
	}


	public void setOccupationText(String occupationText) {
		this.occupationText = occupationText;
	}

	@SuppressWarnings("serial")
	public HashMap<Integer, String> constGender = new HashMap<Integer, String>(){
		{
			put(1, "j");
			put(2, "");
		}
	};
	
	@SuppressWarnings("serial")
	public HashMap<Integer, String> constOccupation = new HashMap<Integer, String>(){
		{
			put(1, "Ј");
			put(2, "");
			put(3, "Ж");
			put(4, "c");
			put(5, "_ѐY");
			put(6, "R");
			put(7, "p[g^C}[");
			put(8, "w");
			put(9, "̑");
			put(10, "E");
		}
	};
	
	public ActionErrors checkValidate(ActionMapping mapping,
								HttpServletRequest req){
		
		ActionErrors errors = new ActionErrors();
		
		String seiKanji = req.getParameter("seiKanji");
		String meiKanji = req.getParameter("meiKanji");
		String seiKana = req.getParameter("seiKana");
		String meiKana = req.getParameter("meiKana");
		String birthDate = req.getParameter("birthDate");
		String gender = req.getParameter("gender");
		String zip1 = req.getParameter("zip1");
		String zip2 = req.getParameter("zip2");
		String address1 = req.getParameter("address1");
		String address2 = req.getParameter("address2");
		String address3 = req.getParameter("address3");
		String address4 = req.getParameter("address4");
		String tel1 = req.getParameter("tel1");
		String tel2 = req.getParameter("tel2");
		String tel3 = req.getParameter("tel3");
		String mTel1 = req.getParameter("mTel1");
		String mTel2 = req.getParameter("mTel2");
		String mTel3 = req.getParameter("mTel3");
		String email1 = req.getParameter("email1");
		String email2 = req.getParameter("email2");
		String occupation = req.getParameter("occupation");
		
		// of[Viijj
		if(seiKanji == null || seiKanji.equals("")){
			errors.add("seiKanji", new ActionMessage("error.seiKanji.required"));
		} else {
			if(CommonUtil.includeHarfCharacter(seiKanji)){
				errors.add("seiKanji", new ActionMessage("error.seiKanji.includeHarfChar"));
			}
			
			if(CommonUtil.includeZenAlphabet(seiKanji)){
				errors.add("seiKanji", new ActionMessage("error.seiKanji.includeZenAlphabet"));
			}
			
			if(CommonUtil.includeZenNumeric(seiKanji)){
				errors.add("seiKanji", new ActionMessage("error.seiKanji.includeZenNumeric"));
			}
			
			if(CommonUtil.includeSpecialCharacter(seiKanji)){
				errors.add("seiKanji", new ActionMessage("error.seiKanji.includeSpecialCharacter"));
			}
			
			if(seiKanji.length() > 20){
				errors.add("seiKanji", new ActionMessage("error.seiKanji.maxLength"));
			}
		}
		
		// of[Viijj
		if(meiKanji == null || meiKanji.equals("")){
			errors.add("meiKanji", new ActionMessage("error.meiKanji.required"));
		} else {
			if(CommonUtil.includeHarfCharacter(meiKanji)){
				errors.add("meiKanji", new ActionMessage("error.meiKanji.includeHarfChar"));
			}
			
			if(CommonUtil.includeZenAlphabet(meiKanji)){
				errors.add("meiKanji", new ActionMessage("error.meiKanji.includeZenAlphabet"));
			}
			
			if(CommonUtil.includeZenNumeric(meiKanji)){
				errors.add("meiKanji", new ActionMessage("error.meiKanji.includeZenNumeric"));
			}
			
			if(CommonUtil.includeSpecialCharacter(meiKanji)){
				errors.add("meiKanji", new ActionMessage("error.meiKanji.includeSpecialCharacter"));
			}
			
			if(seiKanji.length() > 20){
				errors.add("meiKanji", new ActionMessage("error.meiKanji.maxLength"));
			}	
		}
		
		// of[ViiJijj
		if(seiKana == null || seiKana.equals("")){
			errors.add("seiKana", new ActionMessage("error.seiKana.required"));
		} else {
			if(!CommonUtil.isKatakana(seiKana)){
				errors.add("seiKana", new ActionMessage("error.seiKana.isKatakana"));
			}
				
			if(seiKana.length() > 20){
				errors.add("seiKana", new ActionMessage("error.seiKana.maxLength"));
			}	
		}
	
		// of[ViiJijj
		if(meiKana == null || meiKana.equals("")){
			errors.add("meiKana", new ActionMessage("error.meiKana.required"));
		} else {
			if(!CommonUtil.isKatakana(seiKana)){
				errors.add("meiKana", new ActionMessage("error.meiKana.isKatakana"));
			}
				
			if(meiKana.length() > 20){
				errors.add("meiKana", new ActionMessage("error.meiKana.maxLength"));
			}	
		}
		
		// of[ViNj
		if(birthDate == null || birthDate.equals("")){
			errors.add("birthDate", new ActionMessage("error.birthDate.required"));
		} else {
			if(birthDate.length() != 8){
				errors.add("birthDate", new ActionMessage("error.birthDate.length"));
			} else {
				try{
					String year = birthDate.substring(0,4);
					String month = birthDate.substring(4,6);
					String day = birthDate.substring(6,8);
					
					DateFormat df = DateFormat.getDateInstance();
					df.setLenient(false);
					Date d = df.parse(year + "/" + month + "/" + day);
					
					if (d == null){
						errors.add("birthDate", new ActionMessage("error.birthDate.wrong"));
					}
										
				} catch (Exception e){
					errors.add("birthDate", new ActionMessage("error.birthDate.wrong"));
				}
			}
		}
		
		// of[V()
		if(gender == null || gender.equals("")){
			errors.add("gender", new ActionMessage("error.gender.required"));
		}
		
		// of[ViX֔ԍPj
		if(zip1 == null || zip1.equals("")){
			errors.add("zip1", new ActionMessage("error.zip1.required"));
		} else {
			if(!CommonUtil.isNumeric(zip1)){
				errors.add("zip1", new ActionMessage("error.zip1.isNumeric"));
			}
				
			if(zip1.length() != 3){
				errors.add("zip1", new ActionMessage("error.zip1.length"));
			}	
		}
		
		// of[ViX֔ԍQj
		if(zip2 == null || zip2.equals("")){
			errors.add("zip2", new ActionMessage("error.zip2.required"));
		} else {
			if(!CommonUtil.isNumeric(zip2)){
				errors.add("zip2", new ActionMessage("error.zip2.isNumeric"));
			}
				
			if(zip2.length() != 4){
				errors.add("zip2", new ActionMessage("error.zip2.length"));
			}	
		}
		
		// of[ViZPj
		if(address1 == null || address1.equals("")){
			errors.add("address1", new ActionMessage("error.address1.required"));
		} else {
			if(CommonUtil.includeHarfCharacter(address1)){
				errors.add("address1", new ActionMessage("error.address1.includeHarfChar"));
			}
			
			if(CommonUtil.includeSpecialCharacter(address1)){
				errors.add("address1", new ActionMessage("error.address1.includeSpecialCharacter"));
			}
				
			if(address1.length() > 30){
				errors.add("address1", new ActionMessage("error.address1.length"));
			}	
		}
		
		// of[ViZQj
		if(address2 == null || address2.equals("")){
			errors.add("address2", new ActionMessage("error.address2.required"));
		} else {
			if(CommonUtil.includeHarfCharacter(address2)){
				errors.add("address2", new ActionMessage("error.address2.includeHarfChar"));
			}
			
			if(CommonUtil.includeSpecialCharacter(address2)){
				errors.add("address2", new ActionMessage("error.address2.includeSpecialCharacter"));
			}
				
			if(address2.length() > 30){
				errors.add("address2", new ActionMessage("error.address2.length"));
			}	
		}
	
		// of[ViZRj
		if(address3 == null || address3.equals("")){
			errors.add("address3", new ActionMessage("error.address3.required"));
		} else {
			if(CommonUtil.includeHarfCharacter(address3)){
				errors.add("address3", new ActionMessage("error.address3.includeHarfChar"));
			}
			
			if(CommonUtil.includeSpecialCharacter(address3)){
				errors.add("address3", new ActionMessage("error.address3.includeSpecialCharacter"));
			}
				
			if(address3.length() > 40){
				errors.add("address3", new ActionMessage("error.address3.length"));
			}	
		}
		
		// of[ViZSj
		if(!(address4 == null || address4.equals(""))){
			if(CommonUtil.includeHarfCharacter(address4)){
				errors.add("address4", new ActionMessage("error.address4.includeHarfChar"));
			}
			
			if(CommonUtil.includeSpecialCharacter(address4)){
				errors.add("address4", new ActionMessage("error.address4.includeSpecialCharacter"));
			}
				
			if(address4.length() > 40){
				errors.add("address4", new ActionMessage("error.address4.length"));
			}			
		}

	
		//@dbԍ
		if(tel1.equals("") && tel2.equals("") && tel3.equals("") && mTel1.equals("") && mTel2.equals("") && mTel3.equals("")){
			errors.add("tel1", new ActionMessage("error.tel.required"));	
		}
		
		if(!tel1.equals("") || !tel2.equals("") || !tel3.equals("")){
			if(tel1.length() > 6){
				errors.add("tel1", new ActionMessage("error.tel1.length"));	
			}
			
			if(tel2.length() > 5){
				errors.add("tel2", new ActionMessage("error.tel2.length"));	
			}
			
			if(!tel3.equals("") && tel3.length() != 4){
				errors.add("tel2", new ActionMessage("error.tel3.length"));	
			}
			
			if(tel1.equals("")){
				errors.add("tel1", new ActionMessage("error.tel1.required"));	
			}
			if(tel2.equals("")){
				errors.add("tel2", new ActionMessage("error.tel2.required"));	
			}
			if(tel3.equals("")){
				errors.add("tel3", new ActionMessage("error.tel3.required"));	
			}
			
			if(!CommonUtil.isNumeric(tel1)){
				errors.add("tel1", new ActionMessage("error.tel1.isNumeric"));	
			}
			if(!CommonUtil.isNumeric(tel2)){
				errors.add("tel2", new ActionMessage("error.tel2.isNumeric"));	
			}
			if(!CommonUtil.isNumeric(tel3)){
				errors.add("tel3", new ActionMessage("error.tel3.isNumeric"));	
			}

		}
		
		if(!mTel1.equals("") || !mTel2.equals("") || !mTel3.equals("")){
			if(!mTel1.equals("") && mTel1.length() != 3){
				errors.add("mTel1", new ActionMessage("error.mTel1.length"));	
			}
			
			if(!mTel2.equals("") && mTel2.length() != 4){
				errors.add("mTel2", new ActionMessage("error.mTel2.length"));	
			}
			
			if(!mTel3.equals("") && mTel3.length() != 4){
				errors.add("mTel2", new ActionMessage("error.mTel3.length"));	
			}
			
			if(mTel1.equals("")){
				errors.add("mTel1", new ActionMessage("error.mTel1.required"));	
			}
			if(mTel2.equals("")){
				errors.add("mTel2", new ActionMessage("error.mTel2.required"));	
			}
			if(mTel3.equals("")){
				errors.add("mTel3", new ActionMessage("error.mTel3.required"));	
			}
			
			if(!CommonUtil.isNumeric(mTel1)){
				errors.add("mTel1", new ActionMessage("error.mTel1.isNumeric"));	
			}
			if(!CommonUtil.isNumeric(mTel2)){
				errors.add("mTel2", new ActionMessage("error.mTel2.isNumeric"));	
			}
			if(!CommonUtil.isNumeric(mTel3)){
				errors.add("mTel3", new ActionMessage("error.mTel3.isNumeric"));	
			}

		}
		
		// of[Vi[AhXj
		if(email1 == null || email1.equals("")){
			errors.add("email1", new ActionMessage("error.email1.required"));
		} else {
			if(!CommonUtil.isMail(email1)){
				errors.add("email1", new ActionMessage("error.email1.isMail"));
			}
			
			if(address3.length() > 50){
				errors.add("email1", new ActionMessage("error.email1.length"));
			}	
		}
		
		if(!email1.equals(email2)){
			errors.add("email1", new ActionMessage("error.email1.compare"));
		}
		
		// of[ViEƁj
		if(occupation == null || occupation.equals("")){
			errors.add("occupation", new ActionMessage("error.occupation.required"));
		}
		return errors;
		
	}

}
