package jp.yoyoyoyo.webformmanager.action;

import java.security.MessageDigest;
import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dao.MstUserDAO;
import jp.yoyoyoyo.webformmanager.form.ChangePasswordForm;
import jp.yoyoyoyo.webformmanager.model.MstUser;
import jp.yoyoyoyo.webformmanager.util.CommonUtil;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class ChangePasswordAction extends Action {
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response){
		HttpSession session = request.getSession();
		ChangePasswordForm changePasswordForm = (ChangePasswordForm)form;
		
		if(changePasswordForm.getChangePasswordBack() != null && !changePasswordForm.getChangePasswordBack().equals("")){
			return mapping.findForward("login");	
		} else if (changePasswordForm.getChangePasswordNext() != null && !changePasswordForm.getChangePasswordNext().equals("")){
			// NGXgf[^tH[ɃRs[
			request.setAttribute("id",  request.getParameter("id"));
			request.setAttribute("oldPassword",  request.getParameter("oldPassword"));
			request.setAttribute("password1", request.getParameter("password1"));
			request.setAttribute("password2", request.getParameter("password2"));
			
			MstUserDAO dao = new MstUserDAO();
			MstUser data = null;
			
			try {
				data = dao.getMstUserById(changePasswordForm.getId());
			} catch (SQLException e) {
				mapping.findForward("maintenance");
			}
			
			// ̓pX[hSHA-256ňÍ
			String encryptedPassword = "";
			byte[] binary = changePasswordForm.getOldPassword().getBytes();
			MessageDigest md;
			try{
				md = MessageDigest.getInstance("SHA-256");
				byte[] digest = md.digest(binary);
				
				encryptedPassword = CommonUtil.bytesToHexString(digest);
			}catch(Exception e){
				return mapping.findForward("maintenance");
			}
		
			
			// of[V̎s
			ActionErrors errors = changePasswordForm.checkValidate(mapping, request);
			
			if(data == null){
				errors.add("id", new ActionMessage("error.changePassword.id.notFound"));
			} else if (!data.getPassword().equals(encryptedPassword)){
				errors.add("id", new ActionMessage("error.changePassword.oldPassword.wrong"));
			}
			
			
			
			
			// of[VG[Ƃ
			if(errors.size() > 0){
				// G[eZbg
				saveErrors(request, errors);
				// ͉ʂɖ߂
				return mapping.findForward("changePassword");
			}
			
			changePasswordForm.setMaskedOldPassword(CommonUtil.getMaskPassword(changePasswordForm.getOldPassword()));
			changePasswordForm.setMaskedPassword(CommonUtil.getMaskPassword(changePasswordForm.getPassword1()));
			
			session.setAttribute("changePasswordData", changePasswordForm);
			
			return mapping.findForward("changePasswordConfirm");	
		} else {
			return mapping.findForward("changePassword");	
		
		}
		
	}
}
