package jp.yoyoyoyo.webformmanager.action;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dao.InsertDownloadLogDAO;
import jp.yoyoyoyo.webformmanager.dao.RequestDataDAO;
import jp.yoyoyoyo.webformmanager.form.CsvDownloadForm;
import jp.yoyoyoyo.webformmanager.model.LoginInfo;
import jp.yoyoyoyo.webformmanager.model.RequestData;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CsvDownloadAction extends Action {
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response){
		
		CsvDownloadForm csvDownloadForm = (CsvDownloadForm)form;
		HttpSession session = request.getSession();
		// OC擾
		LoginInfo info = (LoginInfo)session.getAttribute("loginData");
		// OCĂȂƂ̓G[
		if(info == null){
			return mapping.findForward("maintenance");
		}
		// CSVDownloadłȂƂ̓G[
		if(!info.isRoleCSVDownload()){
			return mapping.findForward("maintenance");
		}
		// _E[h{^Ƃ
		if(csvDownloadForm.getDownload() != null && !csvDownloadForm.getDownload().equals("")){
	     	// CSVt@C̐ݒ
	    	String fromDate = request.getParameter("fromDate");
	    	String toDate = request.getParameter("toDate");
	    	String csvFileName = "csv_" + fromDate.replaceAll("/", "") + "_" + toDate.replaceAll("/", "") + ".csv";
			
	    	// CSV_E[h
	    	response.setContentType("application/octet-stream"); 
	    	response.setHeader("Content-Disposition", "attachment;filename=" + csvFileName); 
	    	PrintWriter out; 
	    	try {
	        	out = new PrintWriter(new OutputStreamWriter(response.getOutputStream(), "UTF-8"));
	        	RequestDataDAO dao = new RequestDataDAO();
	        	List<RequestData> list = dao.getRequestData(fromDate, toDate);
	        	
	        	int count = 0;
	        	for(RequestData data : list){
	        		out.print(data.getId() + ",");
	           		out.print(data.getSeiKanji() + ",");
	           		out.print(data.getMeiKanji() + ",");
	           		out.print(data.getSeiKana() + ",");
	           		out.print(data.getMeiKana() + ",");
	           		out.print(data.getBirthDate() + ",");
	           		out.print(data.getGenderText() + ",");
	           		out.print(data.getZip1() + ",");
	           		out.print(data.getZip2() + ",");
	           		out.print(data.getAddress1() + ",");
	           		out.print(data.getAddress2() + ",");
	           		out.print(data.getAddress3() + ",");
	           		out.print(replaceNull(data.getAddress4()) + ",");
	           		out.print(replaceNull(data.getTel1()) + ",");
	           		out.print(replaceNull(data.getTel2()) + ",");
	           		out.print(replaceNull(data.getTel3()) + ",");
	           		out.print(replaceNull(data.getmTel1()) + ",");
	           		out.print(replaceNull(data.getmTel2()) + ",");
	           		out.print(replaceNull(data.getmTel3()) + ",");
	           		out.print(data.getEmail() + ",");
	           		out.print(data.getOccupationText() + ",");
	           		out.print(data.getIpAddress() + ",");
	           		out.print(data.getSessionId());
	           		out.println();
	           		count++;
	         	}
	        	
	           	out.flush();
	           	
	           	//@_E[hL^
	           	InsertDownloadLogDAO dao2 = new InsertDownloadLogDAO();
	          
	           	try{
	           		dao2.executeSP(info.getOperatorId(), csvFileName, count, request.getRemoteAddr(), session.getId());
	           	} catch (Exception e){
	           		return mapping.findForward("maintenance");
	           	}
	 
	    	
	    	} catch (Exception e){
	    		return mapping.findForward("maintenance");	
	    	}
			return null;
		} else {
			return mapping.findForward("csvDownload");	
		}
	}
	
	// NULL󕶎ɕϊ
	private String replaceNull(String value){
		if(value == null){
			return "";
		} else {
			return value;
		}
		
	}
 }
