package jp.yoyoyoyo.webformmanager.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.form.EditPasswordForm;
import jp.yoyoyoyo.webformmanager.model.LoginInfo;
import jp.yoyoyoyo.webformmanager.util.CommonUtil;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditPasswordAction extends Action {
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response){
		HttpSession session = request.getSession();
		EditPasswordForm editPasswordForm = (EditPasswordForm)form;
		// OC̎擾
		LoginInfo info = (LoginInfo)session.getAttribute("loginData");
		// OCĂȂƂ̓G[
		if(info == null){
			return mapping.findForward("maintenance");
		}
		// UserManagerłȂƂ̓G[
		if(!info.isRoleUserManager()){
			return mapping.findForward("maintenance");
		}
		if(editPasswordForm.getEditPasswordBack() != null && !editPasswordForm.getEditPasswordBack().equals("")){	// ߂{^Ƃ
			return mapping.findForward("userManager");	
		} else if (editPasswordForm.getEditPasswordNext() != null && !editPasswordForm.getEditPasswordNext().equals("")){	// փ{^Ƃ
			// NGXgf[^tH[ɃRs[
			request.setAttribute("id", (String)session.getAttribute("userId"));
			request.setAttribute("password1", request.getParameter("password1"));
			request.setAttribute("password2", request.getParameter("password2"));
			
			// of[V̎s
			ActionErrors errors = editPasswordForm.checkValidate(mapping, request);
			
			// of[VG[Ƃ
			if(errors.size() > 0){
				// G[eZbg
				saveErrors(request, errors);
				// ͉ʂɖ߂
				return mapping.findForward("editPassword");
			}
			
			editPasswordForm.setId((String)session.getAttribute("userId"));
			editPasswordForm.setMaskedPassword(CommonUtil.getMaskPassword(editPasswordForm.getPassword1()));
			
			session.setAttribute("editPasswordData", editPasswordForm);
			
			return mapping.findForward("editPasswordConfirm");	
		} else {
			String id = request.getParameter("id");
			
			if(id == null || id.equals("")){
				// GETp[^idȂƂ̓ZbV擾
				id = (String)session.getAttribute("userId");
			} else { 
				session.setAttribute("userId", id);
			}
			
			request.setAttribute("id", (String)session.getAttribute("userId"));
			
			return mapping.findForward("editPassword");	
		
		}
		
	}
}
