package jp.yoyoyoyo.webformmanager.action;

import java.security.MessageDigest;
import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dao.UpdatePasswordDAO;
import jp.yoyoyoyo.webformmanager.form.EditPasswordConfirmForm;
import jp.yoyoyoyo.webformmanager.form.EditPasswordForm;
import jp.yoyoyoyo.webformmanager.model.LoginInfo;
import jp.yoyoyoyo.webformmanager.util.CommonUtil;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditPasswordConfirmAction extends Action {
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response){
		HttpSession session = request.getSession();
		EditPasswordConfirmForm editPasswordConfirmForm = (EditPasswordConfirmForm)form;
		// OC̎擾
		LoginInfo info = (LoginInfo)session.getAttribute("loginData");
		// OCĂȂƂ̓G[
		if(info == null){
			return mapping.findForward("maintenance");
		}
		// UserManagerłȂƂ̓G[
		if(!info.isRoleUserManager()){
			return mapping.findForward("maintenance");
		}
		if(editPasswordConfirmForm.getEditPasswordConfirmBack() != null && !editPasswordConfirmForm.getEditPasswordConfirmBack().equals("")){	// ߂{^Ƃ
			EditPasswordForm  editPasswordForm = (EditPasswordForm)session.getAttribute("editPasswordData");
			
			request.setAttribute("id", editPasswordForm.getId());
			request.setAttribute("password1", editPasswordForm.getPassword1());
			request.setAttribute("password2", editPasswordForm.getPassword2());
			return mapping.findForward("editPassword");	
		} else if(editPasswordConfirmForm.getEditPasswordConfirmSave() != null && !editPasswordConfirmForm.getEditPasswordConfirmSave().equals("")){	// ۑ{^Ƃ
			EditPasswordForm  editPasswordForm = (EditPasswordForm)session.getAttribute("editPasswordData");
			
			// pX[hSHA-256ňÍ
			byte[] binary = editPasswordForm.getPassword1().getBytes();
			MessageDigest md;
			try{
				md = MessageDigest.getInstance("SHA-256");
				byte[] digest = md.digest(binary);
					
				editPasswordForm.setEncryptedPassword(CommonUtil.bytesToHexString(digest));
			}catch(Exception e){
				// G[Ƃ
				return mapping.findForward("maintenance");
			}
			
			// pX[hXV
			UpdatePasswordDAO dao = new UpdatePasswordDAO();
			
			try {
				dao.executeSP(editPasswordForm, 1);
			} catch (SQLException e) {
				
				return mapping.findForward("maintenance");
			}
			
			session.removeAttribute("editPasswordData");
			
			return mapping.findForward("messageBox");	
		} else {
			// JSPɒln
			EditPasswordForm  editPasswordForm = (EditPasswordForm)session.getAttribute("editPasswordData");
			
			request.setAttribute("data", editPasswordForm);
			
			return mapping.findForward("editPasswordConfirm");	
		}
	}
}
