package jp.yoyoyoyo.webformmanager.action;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dao.MstUserDAO;
import jp.yoyoyoyo.webformmanager.form.EditUserForm;
import jp.yoyoyoyo.webformmanager.model.LoginInfo;
import jp.yoyoyoyo.webformmanager.model.MstUser;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditUserAction extends Action {
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response){
		HttpSession session = request.getSession();
		EditUserForm editUserForm = (EditUserForm)form;
		// OC̎擾
		LoginInfo info = (LoginInfo)session.getAttribute("loginData");
		// OCĂȂƂ̓G[
		if(info == null){
			return mapping.findForward("maintenance");
		}
		// UserManagerłȂƂ̓G[
		if(!info.isRoleUserManager()){
			return mapping.findForward("maintenance");
		}
		if(editUserForm.getEditUserBack() != null && !editUserForm.getEditUserBack().equals("")){	// ߂{^Ƃ	
			return mapping.findForward("userManager");	
		} else if(editUserForm.getEditUserNext() != null && !editUserForm.getEditUserNext().equals("")){	// փ{^Ƃ
			// NGXgf[^tH[ɃRs[
			request.setAttribute("id", (String)session.getAttribute("userId"));
			request.setAttribute("operatorName", request.getParameter("operatorName"));
			
			// of[V̎s
			ActionErrors errors = editUserForm.checkValidate(mapping, request);
			
			// of[VG[Ƃ
			if(errors.size() > 0){
				// G[eZbg
				saveErrors(request, errors);
				// ͉ʂɖ߂
				return mapping.findForward("editUser");
			}
			
			editUserForm.setRoleText(editUserForm.getRoleTextString());
			
			editUserForm.setId((String)session.getAttribute("userId"));
			session.setAttribute("editUserData", editUserForm);
			
			return mapping.findForward("editUserConfirm");	
		} else {
			String id = request.getParameter("id");
			
			if(id == null || id.equals("")){
				// GETp[^idȂƂ̓ZbV擾
				id = (String)session.getAttribute("userId");
			} else { 
				session.setAttribute("userId", id);
			}
			
			// [U擾
			MstUserDAO dao = new MstUserDAO();
			MstUser user = null;
			
			try{
				user = dao.getMstUserById(id);
			} catch (SQLException e){
				return mapping.findForward("maintenance");	
			}
			
			request.setAttribute("id", user.getOperatorId());
			request.setAttribute("operatorName", user.getOperatorName());
			
			editUserForm.setRole(user.getRole());
			if(user.getLockFlag() == 1){
				editUserForm.setLock(true);
			} else {
				editUserForm.setLock(false);
			}
			if(user.getDisabled() == 1){
				editUserForm.setDisabled(true);
			} else {
				editUserForm.setDisabled(false);
			}
			
			return mapping.findForward("editUser");			
		}
	}
}
