package jp.yoyoyoyo.webformmanager.action;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dao.UpdateMstUserDAO;
import jp.yoyoyoyo.webformmanager.form.EditUserConfirmForm;
import jp.yoyoyoyo.webformmanager.form.EditUserForm;
import jp.yoyoyoyo.webformmanager.model.LoginInfo;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditUserConfirmAction extends Action {
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response){
		HttpSession session = request.getSession();
		EditUserConfirmForm editUserConfirmForm = (EditUserConfirmForm)form;
		// OC̎擾
		LoginInfo info = (LoginInfo)session.getAttribute("loginData");
		
		// OCĂȂƂ̓G[
		if(info == null){
			return mapping.findForward("maintenance");
		}
		// UserManagerłȂƂ̓G[
		if(!info.isRoleUserManager()){
			return mapping.findForward("maintenance");
		}
		if(editUserConfirmForm.getEditUserConfirmBack() != null && !editUserConfirmForm.getEditUserConfirmBack().equals("")){	// ߂{^Ƃ
			EditUserForm  editUserForm = (EditUserForm)session.getAttribute("editUserData");
			
			request.setAttribute("id", editUserForm.getId());
			request.setAttribute("operatorName", editUserForm.getOperatorName());
					
			return mapping.findForward("editUser");	
		} else if(editUserConfirmForm.getEditUserConfirmSave() != null && !editUserConfirmForm.getEditUserConfirmSave().equals("")){	// ۑ{^Ƃ
			EditUserForm  editUserForm = (EditUserForm)session.getAttribute("editUserData");
			
			editUserForm.setRoleValueText(editUserForm.getRoleValueTextString());
			
			// [U}X^̍XV
			UpdateMstUserDAO dao = new UpdateMstUserDAO();
			
			try {
				dao.executeSP(editUserForm);
			} catch (SQLException e) {
				
				return mapping.findForward("maintenance");
			}
			
			session.removeAttribute("editUserData");
			
			return mapping.findForward("messageBox");	
		} else {
		
			// JSPɒln
			EditUserForm  editUserForm = (EditUserForm)session.getAttribute("editUserData");
		
			request.setAttribute("data", editUserForm);
		
			return mapping.findForward("editUserConfirm");	

		}
	}
}
