package jp.yoyoyoyo.webformmanager.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dao.DownloadLogDAO;
import jp.yoyoyoyo.webformmanager.form.LogDownloadForm;
import jp.yoyoyoyo.webformmanager.model.DownloadLog;
import jp.yoyoyoyo.webformmanager.model.LoginInfo;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LogDownloadAction extends Action {
	
	private static final int PAGE_SIZE = 50;
	
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response){
		
		HttpSession session = request.getSession();
		LogDownloadForm logDownloadForm = (LogDownloadForm)form;
		// OC擾
		LoginInfo info = (LoginInfo)session.getAttribute("loginData");
		// OCĂȂƂ̓G[
		if(info == null){
			return mapping.findForward("maintenance");
		}
		// UserManagerłȂƂ̓G[
		if(!info.isRoleUserManager()){
			return mapping.findForward("maintenance");
		}
		if(logDownloadForm.getSearch() != null && !logDownloadForm.getSearch().equals("")){	// {^Ƃ
			// ɍf[^Ă
			DownloadLogDAO dao = new DownloadLogDAO();
			List<DownloadLog> list = null;
			try {
				list = dao.getDownloadLog(logDownloadForm.getSearchString());
			} catch (SQLException e) {
				return mapping.findForward("maintenance");
			}
			
			session.setAttribute("DownloadLogData", list);
			session.setAttribute("DownloadLogDataPage", 0);
			
			int maxPage = (int)(list.size() / PAGE_SIZE);
			
			if(list.size() % PAGE_SIZE == 0){
				maxPage--;
			}
			
			session.setAttribute("DownloadLogDataMaxPage", maxPage);
				
			request.setAttribute("logList", getShowData(list, 0));
			
			request.setAttribute("page", 0);
			
			request.setAttribute("maxPage", maxPage);
			
			return mapping.findForward("logDownload");
		} else if(logDownloadForm.getNext() != null && !logDownloadForm.getNext().equals("")){	// y[Wiցj{^Ƃ
			int page = (int)session.getAttribute("DownloadLogDataPage");
			int maxPage = (int)session.getAttribute("DownloadLogDataMaxPage");
			
			page++;
			
			session.setAttribute("DownloadLogDataPage", page);
			List<DownloadLog> list = (List<DownloadLog>)session.getAttribute("DownloadLogData");
			
			request.setAttribute("logList", getShowData(list, page));
			
			request.setAttribute("page", page);
			request.setAttribute("maxPage", maxPage);
			
			
			return mapping.findForward("logDownload");
		} else if(logDownloadForm.getPrev() != null && !logDownloadForm.getPrev().equals("")){	// y[WiOցj{^Ƃ
			int page = (int)session.getAttribute("DownloadLogDataPage");
			int maxPage = (int)session.getAttribute("DownloadLogDataMaxPage");
			
			page--;
			
			session.setAttribute("DownloadLogDataPage", page);
			List<DownloadLog> list = (List<DownloadLog>)session.getAttribute("DownloadLogData");
			
			request.setAttribute("logList", getShowData(list, page));
			
			request.setAttribute("page", page);
			request.setAttribute("maxPage", maxPage);

			
			return mapping.findForward("logDownload");
		} else {
			return mapping.findForward("logDownload");
		}
	}
	
	// y[WԍYf[^擾
	private List<DownloadLog> getShowData(List<DownloadLog> data, int page){
		List<DownloadLog> list = new ArrayList<DownloadLog>();
		
		int startCount = page * PAGE_SIZE;
		
		for(int i = startCount; i < startCount + PAGE_SIZE; i++){
			if(i >= data.size()){
				break;
			}
			list.add(data.get(i));
		}
		
		return list;
	}
}
