package jp.yoyoyoyo.webformmanager.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dao.LoginLogDAO;
import jp.yoyoyoyo.webformmanager.form.LogLoginForm;
import jp.yoyoyoyo.webformmanager.model.LoginInfo;
import jp.yoyoyoyo.webformmanager.model.LoginLog;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LogLoginAction extends Action {
	
	private static final int PAGE_SIZE = 50;
	
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response){
		
		HttpSession session = request.getSession();
		LogLoginForm logLoginForm = (LogLoginForm)form;
		// OC擾
		LoginInfo info = (LoginInfo)session.getAttribute("loginData");
		
		// OCĂȂƂ̓G[
		if(info == null){
			return mapping.findForward("maintenance");
		}
		// UserManagerłȂƂ̓G[
		if(!info.isRoleUserManager()){
			return mapping.findForward("maintenance");
		}
		if(logLoginForm.getSearch() != null && !logLoginForm.getSearch().equals("")){	// {^Ƃ
			
			// Ńf[^Ă
			LoginLogDAO dao = new LoginLogDAO();
			List<LoginLog> list = null;
			try {
				list = dao.getLoginLog(logLoginForm.getSearchString());
			} catch (SQLException e) {
				return mapping.findForward("maintenance");
			}
			
			session.setAttribute("LoginLogData", list);
			session.setAttribute("LoginLogDataPage", 0);
			
			int maxPage = (int)(list.size() / PAGE_SIZE);
			
			if(list.size() % PAGE_SIZE == 0){
				maxPage--;
			}
			
			session.setAttribute("LoginLogDataMaxPage", maxPage);
				
			request.setAttribute("logList", getShowData(list, 0));
			
			request.setAttribute("page", 0);
			
			request.setAttribute("maxPage", maxPage);
			
			return mapping.findForward("logLogin");
		} else if(logLoginForm.getNext() != null && !logLoginForm.getNext().equals("")){	// y[Wiցj{^Ƃ
			int page = (int)session.getAttribute("LoginLogDataPage");
			int maxPage = (int)session.getAttribute("LoginLogDataMaxPage");
			
			page++;
			
			session.setAttribute("LoginLogDataPage", page);
			List<LoginLog> list = (List<LoginLog>)session.getAttribute("LoginLogData");
			
			request.setAttribute("logList", getShowData(list, page));
			
			request.setAttribute("page", page);
			request.setAttribute("maxPage", maxPage);
			
			
			return mapping.findForward("logLogin");
		} else if(logLoginForm.getPrev() != null && !logLoginForm.getPrev().equals("")){	// y[WiOցj{^Ƃ
			int page = (int)session.getAttribute("LoginLogDataPage");
			int maxPage = (int)session.getAttribute("LoginLogDataMaxPage");
			
			page--;
			
			session.setAttribute("LoginLogDataPage", page);
			List<LoginLog> list = (List<LoginLog>)session.getAttribute("LoginLogData");
			
			request.setAttribute("logList", getShowData(list, page));
			
			request.setAttribute("page", page);
			request.setAttribute("maxPage", maxPage);

			
			return mapping.findForward("logLogin");
		} else {
			return mapping.findForward("logLogin");
		}
	}
	
	// w̃y[Wԍ̃f[^擾
	private List<LoginLog> getShowData(List<LoginLog> data, int page){
		List<LoginLog> list = new ArrayList<LoginLog>();
		
		int startCount = page * PAGE_SIZE;
		
		for(int i = startCount; i < startCount + PAGE_SIZE; i++){
			if(i >= data.size()){
				break;
			}
			list.add(data.get(i));
		}
		
		return list;
	}
}
