package jp.yoyoyoyo.webformmanager.action;

import java.security.MessageDigest;
import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dao.InsertMstUserDAO;
import jp.yoyoyoyo.webformmanager.form.NewUserConfirmForm;
import jp.yoyoyoyo.webformmanager.form.NewUserForm;
import jp.yoyoyoyo.webformmanager.model.LoginInfo;
import jp.yoyoyoyo.webformmanager.util.CommonUtil;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class NewUserConfirmAction extends Action {
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response){
		HttpSession session = request.getSession();
		NewUserConfirmForm 	newUserConfirmForm = (NewUserConfirmForm)form;
		
		// OC̎擾
		LoginInfo info = (LoginInfo)session.getAttribute("loginData");
		// OCĂȂƂ̓G[
		if(info == null){
			return mapping.findForward("maintenance");
		}
		// UserManagerłȂƂ̓G[
		if(!info.isRoleUserManager()){
			return mapping.findForward("maintenance");
		}
		if(newUserConfirmForm.getNewUserConfirmBack() != null && !newUserConfirmForm.getNewUserConfirmBack().equals("")){ // ߂{^Ƃ
			NewUserForm  newUserForm = (NewUserForm)session.getAttribute("newUserData");
				
			// l̕
			request.setAttribute("id", newUserForm.getId());
			request.setAttribute("operatorName", newUserForm.getOperatorName());
			
			request.setAttribute("password1", newUserForm.getPassword1());
			request.setAttribute("password2", newUserForm.getPassword2());
			
			
			return mapping.findForward("newUser");
		} else if(newUserConfirmForm.getNewUserConfirmSave() != null && !newUserConfirmForm.getNewUserConfirmSave().equals("")){	// ۑ{^Ƃ
			NewUserForm  newUserForm = (NewUserForm)session.getAttribute("newUserData");
			
			newUserForm.setRoleValueText(newUserForm.getRoleValueTextString());
			
			// pX[hSHA-256ňÍ
			byte[] binary = newUserForm.getPassword1().getBytes();
			MessageDigest md;
			try{
				md = MessageDigest.getInstance("SHA-256");
				byte[] digest = md.digest(binary);
				
				newUserForm.setEncryptedPassword(CommonUtil.bytesToHexString(digest));
			}catch(Exception e){
				// G[Ƃ
				return mapping.findForward("maintenance");
			}
			
			// [U}X^ɏL^
			InsertMstUserDAO dao = new InsertMstUserDAO();
			
			try {
				dao.executeSP(newUserForm);
			} catch (SQLException e) {
				
				return mapping.findForward("maintenance");
			}
			
			session.removeAttribute("newUserData");
			
			return mapping.findForward("messageBox");
		} else {
			// \f[^JSPɓn
			NewUserForm  newUserForm = (NewUserForm)session.getAttribute("newUserData");
			
			request.setAttribute("data", newUserForm);
			
			return mapping.findForward("newUserConfirm");
			
		}
		
		
	}
}
