package jp.yoyoyoyo.webformmanager.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dao.RequestDataDAO;
import jp.yoyoyoyo.webformmanager.form.StatusForm;
import jp.yoyoyoyo.webformmanager.model.LoginInfo;
import jp.yoyoyoyo.webformmanager.model.RequestData;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class StatusAction extends Action {
	
	private static final int PAGE_SIZE = 50;
	
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response){
		
		StatusForm statusForm = (StatusForm)form;
		HttpSession session = request.getSession();
		
		// OC擾
		LoginInfo info = (LoginInfo)session.getAttribute("loginData");
		
		// OCĂȂƂ̓G[
		if(info == null){
			return mapping.findForward("maintenance");
		}
		
		// Read or WritełȂƂ̓G[
		if(!(info.isRoleRead() || info.isRoleWrite())){
			return mapping.findForward("maintenance");
		}
		
		if(statusForm.getSearch() != null && !statusForm.getSearch().equals("")){	// {^Ƃ	
			// ɂf[^擾
			RequestDataDAO dao = new RequestDataDAO();
			List<RequestData> list = null;
			try {
				list = dao.getRequestData(statusForm.getSearchString());
			} catch (SQLException e) {
				return mapping.findForward("maintenance");
			}
			
			session.setAttribute("RequestData", list);
			session.setAttribute("RequestDataPage", 0);
			
			int maxPage = (int)(list.size() / PAGE_SIZE);
			
			if(list.size() % PAGE_SIZE == 0){
				maxPage--;
			}
			
			session.setAttribute("RequestDataMaxPage", maxPage);
				
			request.setAttribute("statusList", getShowData(list, 0));
			
			request.setAttribute("page", 0);
			
			request.setAttribute("maxPage", maxPage);
			
			return mapping.findForward("status");
		} else if(statusForm.getClear() != null && !statusForm.getClear().equals("")){	// NA{^Ƃ
							
			return mapping.findForward("status");
		} else if(statusForm.getNext() != null && !statusForm.getNext().equals("")){	// y[Wiցj{^Ƃ
			int page = (int)session.getAttribute("RequestDataPage");
			int maxPage = (int)session.getAttribute("RequestDataMaxPage");
			
			page++;
			
			session.setAttribute("RequestDataPage", page);
			List<RequestData> list = (List<RequestData>)session.getAttribute("RequestData");
			
			request.setAttribute("statusList", getShowData(list, page));
			
			request.setAttribute("page", page);
			request.setAttribute("maxPage", maxPage);
			
			return mapping.findForward("status");
		} else if(statusForm.getPrev() != null && !statusForm.getPrev().equals("")){	// y[WiOցj{^Ƃ
			int page = (int)session.getAttribute("RequestDataPage");
			int maxPage = (int)session.getAttribute("RequestDataMaxPage");
			
			page--;
			
			session.setAttribute("RequestDataPage", page);
			List<RequestData> list = (List<RequestData>)session.getAttribute("RequestData");
			
			request.setAttribute("statusList", getShowData(list, page));
			
			request.setAttribute("page", page);
			request.setAttribute("maxPage", maxPage);
			
			return mapping.findForward("status");
		} else {
			return mapping.findForward("status");
		}
		
	}
	
	// \f[^擾
	private List<RequestData> getShowData(List<RequestData> data, int page){
		List<RequestData> list = new ArrayList<RequestData>();
		
		int startCount = page * PAGE_SIZE;
		
		for(int i = startCount; i < startCount + PAGE_SIZE; i++){
			if(i >= data.size()){
				break;
			}
			list.add(data.get(i));
		}
		
		return list;
	}
}
