package jp.yoyoyoyo.webformmanager.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.form.StatusChangeForm;
import jp.yoyoyoyo.webformmanager.model.ChangeStatusData;
import jp.yoyoyoyo.webformmanager.model.LoginInfo;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class StatusChangeAction extends Action {
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response){
		
		StatusChangeForm statusChangeForm = (StatusChangeForm)form;
		HttpSession session = request.getSession();
		
		// OC̎擾
		LoginInfo info = (LoginInfo)session.getAttribute("loginData");
		
		// OCĂȂƂ̓G[
		if(info == null){
			return mapping.findForward("maintenance");
		}
		
		// WritełȂƂ̓G[
		if(!info.isRoleWrite()){
			return mapping.findForward("maintenance");
		}
		
		if(statusChangeForm.getStatusChangeBack() != null && !statusChangeForm.getStatusChangeBack().equals("")){	// ߂{^Ƃ
			return mapping.findForward("detail");
		} else if(statusChangeForm.getStatusChangeNext() != null && !statusChangeForm.getStatusChangeNext().equals("")){	// փ{^Ƃ
			// NGXgf[^tH[ɃRs[
			request.setAttribute("id", request.getParameter("id"));
			request.setAttribute("status", request.getParameter("status"));
			request.setAttribute("comment", request.getParameter("comment"));
			
			// of[V̎s
			ActionErrors errors = statusChangeForm.checkValidate(mapping, request);
			
			// of[VG[Ƃ
			if(errors.size() > 0){
				// G[eZbg
				saveErrors(request, errors);
				// IDĐݒ
				//statusChangeForm.setId((String)session.getAttribute("detailId"));
				request.setAttribute("id", (String)session.getAttribute("detailId"));
				// ͉ʂɖ߂
				return mapping.findForward("statusChange");
			}
	
			// Xe[^XXVIuWFNgɒlZbg
			ChangeStatusData data = new ChangeStatusData();
			
			data.setId((String)session.getAttribute("detailId"));
			data.setOldStatus((int)session.getAttribute("detailStatus"));
			data.setNewStatus(statusChangeForm.getStatus());
			data.setComment(statusChangeForm.getComment());
			
			data.setOldStatusText(data.constStatus.get(data.getOldStatus()));
			data.setNewStatusText(data.constStatus.get(data.getNewStatus()));
			
			session.setAttribute("statusChangeData", data);
			
			return mapping.findForward("statusChangeConfirm");
			
		}  else {	

			//statusChangeForm.setId((String)session.getAttribute("detailId"));
			//statusChangeForm.setStatus((int)session.getAttribute("detailStatus"));
			request.setAttribute("id", (String)session.getAttribute("detailId"));
			request.setAttribute("status", (int)session.getAttribute("detailStatus"));
			
			return mapping.findForward("statusChange");
		}
	}
}
