package jp.yoyoyoyo.webformmanager.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dao.MstUserDAO;
import jp.yoyoyoyo.webformmanager.form.UserManagerForm;
import jp.yoyoyoyo.webformmanager.model.LoginInfo;
import jp.yoyoyoyo.webformmanager.model.MstUser;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UserManagerAction extends Action {
	
	private static final int PAGE_SIZE = 50;
	
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response){
		UserManagerForm userManagerForm = (UserManagerForm)form;
		HttpSession session = request.getSession();
		
		// OC̎擾
		LoginInfo info = (LoginInfo)session.getAttribute("loginData");
		// OCĂȂƂ̓G[
		if(info == null){
			return mapping.findForward("maintenance");
		}
		// UserManagerłȂƂ̓G[
		if(!info.isRoleUserManager()){
			return mapping.findForward("maintenance");
		}
		
		if(userManagerForm.getSearch() != null && !userManagerForm.getSearch().equals("")){ // {^Ƃ
			// of[V̎s
			ActionErrors errors = userManagerForm.checkValidate(mapping, request);
						
			// of[VG[Ƃ
			if(errors.size() > 0){
				// G[eZbg
				saveErrors(request, errors);
				// ͉ʂɖ߂
				return mapping.findForward("userManager");
			}
			
			// ɂă[U擾
			MstUserDAO dao = new MstUserDAO();
			
			List<MstUser> list = null;
			
			try {
				list = dao.getMstUser(userManagerForm.getSearchString());
			} catch (SQLException e) {
				return mapping.findForward("maintenance");
			}
			
			session.setAttribute("UserData", list);
			session.setAttribute("UserDataPage", 0);
			
			int maxPage = (int)(list.size() / PAGE_SIZE);
			
			if(list.size() % PAGE_SIZE == 0){
				maxPage--;
			}
			
			session.setAttribute("UserDataMaxPage", maxPage);
				
			request.setAttribute("userList", getShowData(list, 0));
			
			request.setAttribute("page", 0);
			
			request.setAttribute("maxPage", maxPage);
	
			
			
			return mapping.findForward("userManager");
		} else if(userManagerForm.getNewUser() != null && !userManagerForm.getNewUser().equals("")){	// VK[U{^Ƃ
			session.removeAttribute("newUserData");
			
			return mapping.findForward("newUser");
		} else if(userManagerForm.getNext() != null && !userManagerForm.getNext().equals("")){	// y[Wiցj{^Ƃ
			int page = (int)session.getAttribute("UserDataPage");
			int maxPage = (int)session.getAttribute("UserDataMaxPage");
			
			page++;
			
			session.setAttribute("UserDataPage", page);
			List<MstUser> list = (List<MstUser>)session.getAttribute("UserData");
			
			request.setAttribute("userList", getShowData(list, page));
			
			request.setAttribute("page", page);
			request.setAttribute("maxPage", maxPage);
			
			return mapping.findForward("userManager");
		} else if(userManagerForm.getPrev() != null && !userManagerForm.getPrev().equals("")){	// y[Wi߂j{^Ƃ
			int page = (int)session.getAttribute("UserDataPage");
			int maxPage = (int)session.getAttribute("UserDataMaxPage");
			
			page--;
			
			session.setAttribute("UserDataPage", page);
			List<MstUser> list = (List<MstUser>)session.getAttribute("UserData");
			
			request.setAttribute("userList", getShowData(list, page));
			
			request.setAttribute("page", page);
			request.setAttribute("maxPage", maxPage);
			
			return mapping.findForward("userManager");	
		} else {
			return mapping.findForward("userManager");
		}
		
		
	}
	
	// ݂̕\f[^擾
	private List<MstUser> getShowData(List<MstUser> data, int page){
		List<MstUser> list = new ArrayList<MstUser>();
		
		int startCount = page * PAGE_SIZE;
		
		for(int i = startCount; i < startCount + PAGE_SIZE; i++){
			if(i >= data.size()){
				break;
			}
			list.add(data.get(i));
		}
		
		return list;
	}
}
