package jp.yoyoyoyo.webformmanager.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

public class CheckNewUserDAO {
	// f[^ꗗSQL
	private static final String SELECT = "select * from MST_USER Where OPERATOR_ID = ?";

	private DataSource source;
	
	public CheckNewUserDAO(){
		source = DaoUtil.getSource();
	}
	
	public boolean IsOperatorId(String id) throws SQLException {
		Connection conn = source.getConnection();
		ResultSet rs = null;
		
		// Xe[gg쐬
		PreparedStatement stmt = conn.prepareStatement(SELECT); 
		try{
		   	stmt.setString(1, id);
		   	rs = stmt.executeQuery();
		   	
		   	
		   	if(rs.next()){
		   		return true;
		   	} else {
		   		return false;
		   	}
		   	
		} catch (SQLException e){
		   	throw e;
		} finally {
			    
		   	if(rs != null){
		   		rs.close();
		   	}
			    	
		   	if(stmt != null){
		   		stmt.close();
		   	}
		    	
		   	if(conn != null){
		   		conn.close();
		   	}
		}
	}
}
