package jp.yoyoyoyo.webformmanager.dao;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

public class ExecuteLoginDAO {
	private DataSource source;
	
	public ExecuteLoginDAO(){
		source = DaoUtil.getSource();
	}
	
	public void executeSP(String operatorId, int successful, int failedCount, int lockFlag, String ipAddress, String sessionId) throws SQLException{
		CallableStatement objSql = null;
		Connection db = null;
				
		try {
			db = source.getConnection();
			
			objSql = db.prepareCall("{call EXECUTE_LOGIN(?,?,?,?,?,?)}");
			
			objSql.setString(1, operatorId);
			objSql.setInt(2, successful);
			objSql.setInt(3, failedCount);
			objSql.setInt(4, lockFlag);
			objSql.setString(5, ipAddress);
			objSql.setString(6, sessionId);
			
		    objSql.executeUpdate();
		    
		    
		} catch (SQLException sqlex){
			sqlex.printStackTrace();
			throw sqlex;
		} finally {
			if(db != null){
				db.close();			
			}
		}
	}
	
}
