package jp.yoyoyoyo.webformmanager.dao;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

public class InsertDownloadLogDAO {
	private DataSource source;
	
	public InsertDownloadLogDAO(){
		source = DaoUtil.getSource();
	}
	
	public void executeSP(String operatorId, String filename, int count, String ipAddress, String sessionId) throws SQLException{
		CallableStatement objSql = null;
		Connection db = null;
				
		try {
			db = source.getConnection();
			
			objSql = db.prepareCall("{call INSERT_DOWNLOAD_LOG(?,?,?,?,?)}");
			
			objSql.setString(1, operatorId);
			objSql.setString(2, filename);
			objSql.setInt(3, count);
			objSql.setString(4, ipAddress);
			objSql.setString(5, sessionId);
			
		    objSql.executeUpdate();
		    
		    
		} catch (SQLException sqlex){
			sqlex.printStackTrace();
			throw sqlex;
		} finally {
			if(db != null){
				db.close();			
			}
		}
	}
	
}
