package jp.yoyoyoyo.webformmanager.dao;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import jp.yoyoyoyo.webformmanager.form.NewUserForm;

public class InsertMstUserDAO {
private DataSource source;
	
	public InsertMstUserDAO(){
		source = DaoUtil.getSource();
	}
	
	public void executeSP(NewUserForm data) throws SQLException{
		CallableStatement objSql = null;
		Connection db = null;
				
		try {
			db = source.getConnection();
			
			objSql = db.prepareCall("{call INSERT_MST_USER(?,?,?,?,?)}");
			
			objSql.setString(1, data.getId());
			objSql.setString(2, data.getEncryptedPassword());
			objSql.setString(3, data.getOperatorName());
			objSql.setString(4, data.getRoleValueText());
			objSql.setString(5, data.getRoleText());
			
		    objSql.executeUpdate();
		    
		    
		} catch (SQLException sqlex){
			sqlex.printStackTrace();
			throw sqlex;
		} finally {
			if(db != null){
				db.close();			
			}
		}
	}
	
}
