package jp.yoyoyoyo.webformmanager.dao;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import jp.yoyoyoyo.webformmanager.model.ChangeStatusData;

public class InsertStatusHistoryDAO {
	private DataSource source;
	
	public InsertStatusHistoryDAO(){
		source = DaoUtil.getSource();
	}
	
	public void executeSP(ChangeStatusData data) throws SQLException{
		CallableStatement objSql = null;
		Connection db = null;
				
		try {
			db = source.getConnection();
			
			objSql = db.prepareCall("{call INSERT_STATUS_HISTORY(?,?,?,?,?,?,?)}");
			
			objSql.setInt(1,Integer.parseInt(data.getId()));
			objSql.setInt(2,data.getNewStatus());
		    objSql.setString(3, data.getNewStatusText());
		    objSql.setInt(4,data.getOldStatus());
		    objSql.setString(5, data.getOldStatusText());
		    objSql.setString(6, data.getComment());
		    objSql.setString(7, data.getOperatorId()); 
			
		    objSql.executeUpdate();
		    
		    
		} catch (SQLException sqlex){
			sqlex.printStackTrace();
			throw sqlex;
		} finally {
			if(db != null){
				db.close();			
			}
		}
	}
	
}
