package jp.yoyoyoyo.webformmanager.dao;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import jp.yoyoyoyo.webformmanager.form.EditUserForm;

public class UpdateMstUserDAO {
private DataSource source;
	
	public UpdateMstUserDAO(){
		source = DaoUtil.getSource();
	}
	
	public void executeSP(EditUserForm data) throws SQLException{
		CallableStatement objSql = null;
		Connection db = null;
				
		try {
			db = source.getConnection();
			
			objSql = db.prepareCall("{call UPDATE_MST_USER(?,?,?,?,?,?)}");
			
			objSql.setString(1, data.getId());
			objSql.setString(2, data.getOperatorName());
			objSql.setString(3, data.getRoleValueText());
			objSql.setString(4, data.getRoleText());
			if(data.isLock()){
				objSql.setInt(5,1);
			} else {
				objSql.setInt(5,0);
			}
			if(data.isDisabled()){
				objSql.setInt(6,1);
			} else {
				objSql.setInt(6,0);
			}
			
		    objSql.executeUpdate();
		    
		    
		} catch (SQLException sqlex){
			sqlex.printStackTrace();
			throw sqlex;
		} finally {
			if(db != null){
				db.close();			
			}
		}
	}
	
}
