package jp.yoyoyoyo.webformmanager.dao;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import jp.yoyoyoyo.webformmanager.form.ChangePasswordForm;
import jp.yoyoyoyo.webformmanager.form.EditPasswordForm;

public class UpdatePasswordDAO {
private DataSource source;
	
	public UpdatePasswordDAO(){
		source = DaoUtil.getSource();
	}
	
	public void executeSP(EditPasswordForm data, int initialFlag) throws SQLException{
		CallableStatement objSql = null;
		Connection db = null;
				
		try {
			db = source.getConnection();
			
			objSql = db.prepareCall("{call UPDATE_PASSWORD(?,?,?)}");
			
			objSql.setString(1, data.getId());
			objSql.setInt(2, initialFlag);
			objSql.setString(3, data.getEncryptedPassword());
			
			
		    objSql.executeUpdate();
		    
		    
		} catch (SQLException sqlex){
			sqlex.printStackTrace();
			throw sqlex;
		} finally {
			if(db != null){
				db.close();			
			}
		}
	}
	
	public void executeSP(ChangePasswordForm data, int initialFlag) throws SQLException{
		CallableStatement objSql = null;
		Connection db = null;
				
		try {
			db = source.getConnection();
			
			objSql = db.prepareCall("{call UPDATE_PASSWORD(?,?,?)}");
			
			objSql.setString(1, data.getId());
			objSql.setInt(2, initialFlag);
			objSql.setString(3, data.getEncryptedPassword());
			
			
		    objSql.executeUpdate();
		    
		    
		} catch (SQLException sqlex){
			sqlex.printStackTrace();
			throw sqlex;
		} finally {
			if(db != null){
				db.close();			
			}
		}
	}
}
