package jp.yoyoyoyo.webformmanager.form;

import javax.servlet.http.HttpServletRequest;

import jp.yoyoyoyo.webformmanager.util.CommonUtil;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class ChangePasswordForm extends ActionForm {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String id;
	
	private String OldPassword;
	
	private String maskedOldPassword;
	
	private String password1;
	
	private String password2;
	
	private String maskedPassword;
	
	private String encryptedPassword;
	
	private String changePasswordBack;
	
	private String changePasswordNext;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getOldPassword() {
		return OldPassword;
	}

	public void setOldPassword(String oldPassword) {
		OldPassword = oldPassword;
	}

	public String getMaskedOldPassword() {
		return maskedOldPassword;
	}

	public void setMaskedOldPassword(String maskedOldPassword) {
		this.maskedOldPassword = maskedOldPassword;
	}

	public String getPassword1() {
		return password1;
	}

	public void setPassword1(String password1) {
		this.password1 = password1;
	}

	public String getPassword2() {
		return password2;
	}

	public void setPassword2(String password2) {
		this.password2 = password2;
	}

	public String getMaskedPassword() {
		return maskedPassword;
	}

	public void setMaskedPassword(String maskedPassword) {
		this.maskedPassword = maskedPassword;
	}

	public String getEncryptedPassword() {
		return encryptedPassword;
	}

	public void setEncryptedPassword(String encryptedPassword) {
		this.encryptedPassword = encryptedPassword;
	}

	
	public String getChangePasswordBack() {
		return changePasswordBack;
	}

	public void setChangePasswordBack(String changePasswordBack) {
		this.changePasswordBack = changePasswordBack;
	}

	public String getChangePasswordNext() {
		return changePasswordNext;
	}

	public void setChangePasswordNext(String changePasswordNext) {
		this.changePasswordNext = changePasswordNext;
	}

	public ActionErrors checkValidate(ActionMapping mapping,
								HttpServletRequest req){

		ActionErrors errors = new ActionErrors();

		String id = req.getParameter("id");
		String oldPassword = req.getParameter("oldPassword");
		String password1 = req.getParameter("password1");
		String password2 = req.getParameter("password2");

		if(id == null || id.equals("")){
			errors.add("id", new ActionMessage("error.changePassword.id.required"));
		} else {
			if(id.length() > 20){
				errors.add("id", new ActionMessage("error.changePassword.id.length"));
			}

		}
		
		if(oldPassword == null || oldPassword.equals("")){
			errors.add("oldPassword", new ActionMessage("error.changePassword.oldPassword.required"));
		} else {
			if(id.length() > 20){
				errors.add("oldPassword", new ActionMessage("error.changePassword.oldPassword.length"));
			}

		}
		
		if(password1 == null || password1.equals("")){
			errors.add("password1", new ActionMessage("error.changePassword.password1.required"));
		} else {
			if(!CommonUtil.validatePassword(password1)){
				errors.add("password1", new ActionMessage("error.changePassword.password1.validatePassword"));
			}

			if(!password1.equals(password2)){
				errors.add("password1", new ActionMessage("error.changePassword.password1.notCompare"));
			}

		}

		return errors;
	}


}
