package jp.yoyoyoyo.webformmanager.form;

import java.text.DateFormat;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class CsvDownloadForm extends ActionForm {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String fromDate;
	
	private String toDate;
	
	private String download;

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getDownload() {
		return download;
	}

	public void setDownload(String download) {
		this.download = download;
	}
	
	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest req){

		ActionErrors errors = new ActionErrors();
		
		String fromDate = req.getParameter("fromDate");
		String toDate = req.getParameter("toDate");
		
		// of[ViJntj
		if(fromDate == null || fromDate.equals("")){
			errors.add("fromDate", new ActionMessage("error.csvDownload.fromDate.required"));
		} else {	
			try{				
				DateFormat df = DateFormat.getDateInstance();
				df.setLenient(false);
				Date d = df.parse(fromDate);
						
				if (d == null){
					errors.add("fromDate", new ActionMessage("error.csvDownload.fromDate.wrong"));
				}
											
			} catch (Exception e){
				errors.add("fromDate", new ActionMessage("error.csvDownload.fromDate.wrong"));
			}
		}
		
		// of[ViItj
		if(toDate == null || toDate.equals("")){
			errors.add("toDate", new ActionMessage("error.csvDownload.toDate.required"));
		} else {
			try{				
				DateFormat df = DateFormat.getDateInstance();
				df.setLenient(false);
				Date d = df.parse(toDate);
						
				if (d == null){
					errors.add("toDate", new ActionMessage("error.csvDownload.toDate.wrong"));
				}
											
			} catch (Exception e){
				errors.add("toDate", new ActionMessage("error.csvDownload.toDate.wrong"));
			}
		}
		return errors;
	}

}
