package jp.yoyoyoyo.webformmanager.form;

import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.util.CommonUtil;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class EditUserForm extends ActionForm {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String id;
	
	private String operatorName;
	
	private boolean roleRead;
	
	private boolean roleWrite;
	
	private boolean roleCSVDownload;
	
	private boolean roleUserManager;
	
	private String roleValueText;
	
	private String roleText;
	

	private boolean lock;
	
	private boolean disabled;
	
	private String editUserBack;
	
	private String editUserNext;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getOperatorName() {
		return operatorName;
	}

	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	public boolean isRoleRead() {
		return roleRead;
	}

	public void setRoleRead(boolean roleRead) {
		this.roleRead = roleRead;
	}

	public boolean isRoleWrite() {
		return roleWrite;
	}

	public void setRoleWrite(boolean roleWrite) {
		this.roleWrite = roleWrite;
	}

	public boolean isRoleCSVDownload() {
		return roleCSVDownload;
	}

	public void setRoleCSVDownload(boolean roleCSVDownload) {
		this.roleCSVDownload = roleCSVDownload;
	}

	public boolean isRoleUserManager() {
		return roleUserManager;
	}

	public void setRoleUserManager(boolean roleUserManager) {
		this.roleUserManager = roleUserManager;
	}

	public String getRoleValueText() {
		return roleValueText;
	}

	public void setRoleValueText(String roleValueText) {
		this.roleValueText = roleValueText;
	}

	public String getRoleText() {
		return roleText;
	}

	public void setRoleText(String roleText) {
		this.roleText = roleText;
	}

	public boolean isLock() {
		return lock;
	}

	public void setLock(boolean lock) {
		this.lock = lock;
	}

	public boolean isDisabled() {
		return disabled;
	}

	public void setDisabled(boolean disabled) {
		this.disabled = disabled;
	}

	public String getEditUserBack() {
		return editUserBack;
	}

	public void setEditUserBack(String editUserBack) {
		this.editUserBack = editUserBack;
	}

	public String getEditUserNext() {
		return editUserNext;
	}

	public void setEditUserNext(String editUserNext) {
		this.editUserNext = editUserNext;
	}
	
	public String getRoleValueTextString(){
		String tmp = "";

		if(roleRead){
			tmp = tmp + "1,";
		}
		if(roleWrite){
			tmp = tmp + "2,";
		}	
		if(roleCSVDownload){
			tmp = tmp + "3,";
		}
		if(roleUserManager){
			tmp = tmp + "4,";
		}
		
		tmp = tmp.substring(0, tmp.length() - 1);
		
		return tmp;
	}
	
	public String getRoleTextString(){
		String tmp = "";

		if(roleRead){
			tmp = tmp + "Read,";
		}
		if(roleWrite){
			tmp = tmp + "Write,";
		}	
		if(roleCSVDownload){
			tmp = tmp + "CSV Download,";
		}
		if(roleUserManager){
			tmp = tmp + "User Manager,";
		}
		
		tmp = tmp.substring(0, tmp.length() - 1);
		
		return tmp;
	}
	
	public void setRole(String text){
		StringTokenizer st1 = new StringTokenizer(text, ",");
    	
    	roleRead = false;
    	roleWrite = false;
    	roleCSVDownload = false;
    	roleUserManager = false;
    	
    	while(st1.hasMoreTokens()) {
    		String tmp = st1.nextToken();
    		if(tmp.equals("1")){
    			roleRead = true;
    		}
    		if(tmp.equals("2")){
    			roleWrite = true;
    		}
    		if(tmp.equals("3")){
    			roleCSVDownload = true;
    		}
    		if(tmp.equals("4")){
    			roleUserManager = true;
    		}
    	}	
	}

	public ActionErrors checkValidate(ActionMapping mapping,
			HttpServletRequest req){

		ActionErrors errors = new ActionErrors();
		
		String operatorName = req.getParameter("operatorName");
		String roleReadString = req.getParameter("roleRead");
		String roleWriteString = req.getParameter("roleWrite");
		String roleCSVDownloadString = req.getParameter("roleCSVDownload");
		String roleUserManagerString = req.getParameter("roleUserManager");
		
		boolean roleRead = false;
		if(!(roleReadString == null)){
		roleRead = true;
		}
		boolean roleWrite = false;
		if(!(roleWriteString == null)){
		roleWrite = true;
		}
		boolean roleCSVDownload = false;
		if(!(roleCSVDownloadString == null)){
		roleCSVDownload = true;
		}
		boolean roleUserManager = false;
		if(!(roleUserManagerString == null)){
		roleUserManager = true;
		}
		
		
		if(operatorName == null || operatorName.equals("")){
			errors.add("operatorName", new ActionMessage("error.editUser.operatorName.required"));
		} else {
			if(operatorName.length() > 20){
				errors.add("operatorName", new ActionMessage("error.editUser.operatorName.length"));
			}
		
			if(CommonUtil.includeSpecialCharacter(operatorName)){
				errors.add("operatorName", new ActionMessage("error.editUser.operatorName.includeSpecialCharacter"));
			}
		}
		
		if(roleRead == false && roleWrite == false && roleCSVDownload == false && roleUserManager == false){
			errors.add("role", new ActionMessage("error.editUser.role.notSelect"));
		}
		
		return errors;
	}

	public void reset(ActionMapping mapping, HttpServletRequest request){
		HttpSession session = request.getSession();
		
		EditUserForm editUserForm = (EditUserForm)session.getAttribute("editUserData");

		if(editUserForm != null){
			this.roleRead = editUserForm.isRoleRead();
			this.roleWrite = editUserForm.isRoleWrite();
			this.roleCSVDownload = editUserForm.isRoleCSVDownload();
			this.roleUserManager = editUserForm.isRoleUserManager();
			
			this.lock = editUserForm.isLock();
			this.disabled = editUserForm.isDisabled();
		}
		
		session.removeAttribute("editUserData");
	}
}
