package jp.yoyoyoyo.webformmanager.form;

import java.text.DateFormat;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class LogLoginForm extends ActionForm {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String id;
	
	private String fromDate;
	
	private String toDate;
	
	private String viewCount;
	
	private String search;

	private String next;
	
	private String prev;
	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getViewCount() {
		return viewCount;
	}

	public void setViewCount(String viewCount) {
		this.viewCount = viewCount;
	}

	public String getSearch() {
		return search;
	}

	public void setSearch(String search) {
		this.search = search;
	}

	public String getNext() {
		return next;
	}

	public void setNext(String next) {
		this.next = next;
	}

	public String getPrev() {
		return prev;
	}

	public void setPrev(String prev) {
		this.prev = prev;
	}

	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest req){

		ActionErrors errors = new ActionErrors();
	
		String id = req.getParameter("id");
		String fromDate = req.getParameter("fromDate");
		String toDate = req.getParameter("toDate");
		
		// of[ViIy[^IDj
		if(id != null && !id.equals("")){	
			if(id.length() > 20){
				errors.add("id", new ActionMessage("error.logLogin.id.length"));
			}
		}
		
		// of[ViJntj
		if(fromDate != null && !fromDate.equals("")){	
			try{				
				DateFormat df = DateFormat.getDateInstance();
				df.setLenient(false);
				Date d = df.parse(fromDate);
						
				if (d == null){
					errors.add("fromDate", new ActionMessage("error.logLogin.fromDate.wrong"));
				}
													
			} catch (Exception e){
				errors.add("fromDate", new ActionMessage("error.logLogin.fromDate.wrong"));
			}
		}
				
		// of[ViItj
		if(toDate != null && !toDate.equals("")){	
			try{				
				DateFormat df = DateFormat.getDateInstance();
				df.setLenient(false);
				Date d = df.parse(toDate);
							
				if (d == null){
					errors.add("toDate", new ActionMessage("error.logLogin.toDate.wrong"));
				}
												
			} catch (Exception e){
				errors.add("toDate", new ActionMessage("error.logLogin.toDate.wrong"));
			}
		}
		
		return errors;
	}
	
	public String getSearchString(){
		String where = " where 1 = 1";
		
		if(!(id == null)){
			if(!id.equals("")){
				where += " and ";
				where += "OPERATOR_ID = '" + id + "'";
			}			
		}
		
		if(!(fromDate == null)){
			if(!fromDate.equals("")){
				where += " and ";
				where += "LOGIN_DATE > '" + fromDate + "'";
			}
		}
		
		if(!(toDate == null)){
			if(!toDate.equals("")){
				where += " and ";
				where += "LOGIN_DATE < '" + toDate + "'";
			}			
		}
		
		where += " and rownum <= " + viewCount;

		
		return where;
	}
}
