package jp.yoyoyoyo.webformmanager.form;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class LoginForm extends ActionForm {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String operatorId;
	
	private String password;
	
	private String login;

	public String getOperatorId() {
		return operatorId;
	}

	public void setOperatorId(String operatorId) {
		this.operatorId = operatorId;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getLogin() {
		return login;
	}

	public void setLogin(String login) {
		this.login = login;
	}

	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest req){

		ActionErrors errors = new ActionErrors();
	
		String id = req.getParameter("operatorId");
		String password = req.getParameter("password");
		
		if(id == null || id.equals("")){
			errors.add("operatorId", new ActionMessage("error.login.id.required"));
		} else {
			if(id.length() > 20){
				errors.add("operatorId", new ActionMessage("error.login.id.length"));
			}
		}
	
		if(password == null || password.equals("")){
			errors.add("password", new ActionMessage("error.login.password.length"));
		} else {
			if(password.length() > 20){
				errors.add("password", new ActionMessage("error.login.password.length"));
			}
		}
		
		return errors;
	}
	
}
