package jp.yoyoyoyo.webformmanager.form;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.util.CommonUtil;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class NewUserForm extends ActionForm {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String id;
	
	private String operatorName;
	
	private boolean roleRead;
	
	private boolean roleWrite;
	
	private boolean roleCSVDownload;
	
	private boolean roleUserManager;
	
	private String roleValueText;
	
	private String roleText;
	
	private String password1;
	
	private String password2;
	
	private String maskedPassword;
	
	private String encryptedPassword;

	private String newUserBack;
	
	private String newUserNext;
	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getOperatorName() {
		return operatorName;
	}

	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	public boolean isRoleRead() {
		return roleRead;
	}

	public void setRoleRead(boolean roleRead) {
		this.roleRead = roleRead;
	}

	public boolean isRoleWrite() {
		return roleWrite;
	}

	public void setRoleWrite(boolean roleWrite) {
		this.roleWrite = roleWrite;
	}

	public boolean isRoleCSVDownload() {
		return roleCSVDownload;
	}

	public void setRoleCSVDownload(boolean roleCSVDownload) {
		this.roleCSVDownload = roleCSVDownload;
	}

	public boolean isRoleUserManager() {
		return roleUserManager;
	}

	public void setRoleUserManager(boolean roleUserManager) {
		this.roleUserManager = roleUserManager;
	}

	public String getRoleValueText() {
		return roleValueText;
	}

	public void setRoleValueText(String roleValueText) {
		this.roleValueText = roleValueText;
	}

	public String getRoleText() {
		return roleText;
	}

	public void setRoleText(String roleText) {
		this.roleText = roleText;
	}

	public String getPassword1() {
		return password1;
	}

	public void setPassword1(String password1) {
		this.password1 = password1;
	}

	public String getPassword2() {
		return password2;
	}

	public void setPassword2(String password2) {
		this.password2 = password2;
	}

	public String getMaskedPassword() {
		return maskedPassword;
	}

	public void setMaskedPassword(String maskedPassword) {
		this.maskedPassword = maskedPassword;
	}

	public String getEncryptedPassword() {
		return encryptedPassword;
	}

	public void setEncryptedPassword(String encryptedPassword) {
		this.encryptedPassword = encryptedPassword;
	}

	public String getNewUserBack() {
		return newUserBack;
	}

	public void setNewUserBack(String newUserBack) {
		this.newUserBack = newUserBack;
	}

	public String getNewUserNext() {
		return newUserNext;
	}

	public void setNewUserNext(String newUserNext) {
		this.newUserNext = newUserNext;
	}

	public ActionErrors checkValidate(ActionMapping mapping,
										HttpServletRequest req){

		ActionErrors errors = new ActionErrors();
		
		String id = req.getParameter("id");
		String operatorName = req.getParameter("operatorName");
		String roleReadString = req.getParameter("roleRead");
		String roleWriteString = req.getParameter("roleWrite");
		String roleCSVDownloadString = req.getParameter("roleCSVDownload");
		String roleUserManagerString = req.getParameter("roleUserManager");
		boolean roleRead = false;
		if(!(roleReadString == null)){
			roleRead = true;
		}
		boolean roleWrite = false;
		if(!(roleWriteString == null)){
			roleWrite = true;
		}
		boolean roleCSVDownload = false;
		if(!(roleCSVDownloadString == null)){
			roleCSVDownload = true;
		}
		boolean roleUserManager = false;
		if(!(roleUserManagerString == null)){
			roleUserManager = true;
		}
		
		String password1 = req.getParameter("password1");
		String password2 = req.getParameter("password2");
		
		if(id == null || id.equals("")){
			errors.add("id", new ActionMessage("error.newUser.id.required"));
		} else {
			if(id.length() > 20){
				errors.add("id", new ActionMessage("error.newUser.id.length"));
			}
			
			if(!CommonUtil.isOperatorId(id)){
				errors.add("id", new ActionMessage("error.newUser.id.isOperatorId"));
			}

		}
		
		if(operatorName == null || operatorName.equals("")){
			errors.add("operatorName", new ActionMessage("error.newUser.operatorName.required"));
		} else {
			if(operatorName.length() > 20){
				errors.add("operatorName", new ActionMessage("error.newUser.operatorName.length"));
			}
			
			if(CommonUtil.includeSpecialCharacter(operatorName)){
				errors.add("operatorName", new ActionMessage("error.newUser.operatorName.includeSpecialCharacter"));
			}
		}
		
		if(roleRead == false && roleWrite == false && roleCSVDownload == false && roleUserManager == false){
			errors.add("role", new ActionMessage("error.newUser.role.notSelect"));
		}
		
		
		if(password1 == null || password1.equals("")){
			errors.add("password1", new ActionMessage("error.newUser.password1.required"));
		} else {
			if(!CommonUtil.validatePassword(password1)){
				errors.add("password1", new ActionMessage("error.newUser.password1.validatePassword"));
			}
			
			if(!password1.equals(password2)){
				errors.add("password1", new ActionMessage("error.newUser.password1.notCompare"));
			}

		}
		
		return errors;
	}
	
	public String getRoleValueTextString(){
		String tmp = "";

		if(roleRead){
			tmp = tmp + "1,";
		}
		if(roleWrite){
			tmp = tmp + "2,";
		}	
		if(roleCSVDownload){
			tmp = tmp + "3,";
		}
		if(roleUserManager){
			tmp = tmp + "4,";
		}
		
		tmp = tmp.substring(0, tmp.length() - 1);
		
		return tmp;
	}
	
	public String getRoleTextString(){
		String tmp = "";

		if(roleRead){
			tmp = tmp + "Read,";
		}
		if(roleWrite){
			tmp = tmp + "Write,";
		}	
		if(roleCSVDownload){
			tmp = tmp + "CSV Download,";
		}
		if(roleUserManager){
			tmp = tmp + "User Manager,";
		}
		
		tmp = tmp.substring(0, tmp.length() - 1);
		
		return tmp;
	}
	
	public void reset(ActionMapping mapping, HttpServletRequest request){
		HttpSession session = request.getSession();
		
		NewUserForm newUserForm = (NewUserForm)session.getAttribute("newUserData");

		if(newUserForm != null){
			this.roleRead = newUserForm.isRoleRead();
			this.roleWrite = newUserForm.isRoleWrite();
			this.roleCSVDownload = newUserForm.isRoleCSVDownload();
			this.roleUserManager = newUserForm.isRoleUserManager();
		}
		
		session.removeAttribute("newUserData");
	}
}
