package jp.yoyoyoyo.webformmanager.form;

import javax.servlet.http.HttpServletRequest;

import jp.yoyoyoyo.webformmanager.util.CommonUtil;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class StatusChangeForm  extends ActionForm {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String id;
	
	private int status;
	
	private String comment;
	
	private String statusChangeBack;
	
	private String statusChangeNext;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getStatusChangeBack() {
		return statusChangeBack;
	}

	public void setStatusChangeBack(String statusChangeBack) {
		this.statusChangeBack = statusChangeBack;
	}

	public String getStatusChangeNext() {
		return statusChangeNext;
	}

	public void setStatusChangeNext(String statusChangeNext) {
		this.statusChangeNext = statusChangeNext;
	}

	public ActionErrors checkValidate(ActionMapping mapping,
			HttpServletRequest req){

		ActionErrors errors = new ActionErrors();
		
		String comment = req.getParameter("comment");
		
		if(comment != null && !comment.equals("")){
			if(comment.length() > 256){
				errors.add("comment", new ActionMessage("error.statusChange.comment.length"));
			}
			
			if(CommonUtil.includeSpecialCharacter(comment)){
				errors.add("comment", new ActionMessage("error.statusChange.comment.includeSpecialCharacter"));
			}
		}
		
		return errors;
	}
	
}
