package jp.yoyoyoyo.webformmanager.form;

import java.text.DateFormat;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import jp.yoyoyoyo.webformmanager.util.CommonUtil;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class StatusForm extends ActionForm {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String id;
	
	private String seiKanji;
	
	private String meiKanji;
	
	private String seiKana;
	
	private String meiKana;
	
	private String zip;
	
	private String email;
	
	private String fromDate;
	
	private String toDate;
	
	private String viewCount;
	
	private String search;
	
	private String clear;
	
	private String next;
	
	private String prev;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getSeiKanji() {
		return seiKanji;
	}

	public void setSeiKanji(String seiKanji) {
		this.seiKanji = seiKanji;
	}

	public String getMeiKanji() {
		return meiKanji;
	}

	public void setMeiKanji(String meiKanji) {
		this.meiKanji = meiKanji;
	}

	public String getSeiKana() {
		return seiKana;
	}

	public void setSeiKana(String seiKana) {
		this.seiKana = seiKana;
	}

	public String getMeiKana() {
		return meiKana;
	}

	public void setMeiKana(String meiKana) {
		this.meiKana = meiKana;
	}

	public String getZip() {
		return zip;
	}

	public void setZip(String zip) {
		this.zip = zip;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getViewCount() {
		return viewCount;
	}

	public void setViewCount(String viewCount) {
		this.viewCount = viewCount;
	}

	public String getSearch() {
		return search;
	}

	public void setSearch(String search) {
		this.search = search;
	}

	public String getClear() {
		return clear;
	}

	public void setClear(String clear) {
		this.clear = clear;
	}

	public String getNext() {
		return next;
	}

	public void setNext(String next) {
		this.next = next;
	}

	public String getPrev() {
		return prev;
	}

	public void setPrev(String prev) {
		this.prev = prev;
	}
	
	public ActionErrors validate(ActionMapping mapping,
								HttpServletRequest req){

		ActionErrors errors = new ActionErrors();
		
		String id = req.getParameter("id");
		String seiKanji = req.getParameter("seiKanji");
		String meiKanji = req.getParameter("meiKanji");
		String seiKana = req.getParameter("seiKana");
		String meiKana = req.getParameter("meiKana");
		String zip = req.getParameter("zip");
		String email = req.getParameter("email");
		String fromDate = req.getParameter("fromDate");
		String toDate = req.getParameter("toDate");
			
		if(id != null && !id.equals("")){	
			// of[Vi\ԍj
			if(id.length() > 20){
				errors.add("id", new ActionMessage("error.status.id.length"));
			}
			
			try {
				Integer.parseInt(id);
			} catch (NumberFormatException e){
				errors.add("id", new ActionMessage("error.status.id.numeric"));
			}
		}
		
		if(seiKanji != null && !seiKanji.equals("")){	
			// of[Viijj
			if(seiKanji.length() > 20){
				errors.add("seiKanji", new ActionMessage("error.status.seiKanji.length"));
			}
				
		}
		
		if(meiKanji != null && !meiKanji.equals("")){	
			// of[Viijj
			if(meiKanji.length() > 20){
				errors.add("meiKanji", new ActionMessage("error.status.meiKanji.length"));
			}
		}
		
		if(seiKana != null && !seiKana.equals("")){	
			// of[ViiJijj
			if(seiKana.length() > 20){
				errors.add("seiKana", new ActionMessage("error.status.seiKana.length"));
			}
			
			if(!CommonUtil.isKatakana(seiKana)){
				errors.add("seiKana", new ActionMessage("error.status.seiKana.isKatakana"));
			}
		}

		// of[ViiJijj
		if(meiKana != null && !meiKana.equals("")){	
			if(meiKana.length() > 20){
				errors.add("meiKana", new ActionMessage("error.status.meiKana.length"));
			}
			
			if(!CommonUtil.isKatakana(meiKana)){
				errors.add("meiKana", new ActionMessage("error.status.meiKana.isKatakana"));
			}
		}
		
		// X֔ԍ
		if(zip != null && !zip.equals("")){	
			if(zip.length() != 7){
				errors.add("zip", new ActionMessage("error.status.zip.length"));
			}

			try {
				Integer.parseInt(zip);
			} catch (NumberFormatException e){
				errors.add("zip", new ActionMessage("error.status.zip.numeric"));
			}
		}
		
		
		// of[Vi[AhXj
		if(email != null && !email.equals("")){	
			if(email.length() > 50){
				errors.add("email", new ActionMessage("error.status.email.length"));
			}
			
			if(!CommonUtil.isMail(email)){
				errors.add("email", new ActionMessage("error.status.email.isMail"));
			}
		}
		
		// of[ViJntj
		if(fromDate != null && !fromDate.equals("")){	
			try{				
				DateFormat df = DateFormat.getDateInstance();
				df.setLenient(false);
				Date d = df.parse(fromDate);
						
				if (d == null){
					errors.add("fromDate", new ActionMessage("error.status.fromDate.wrong"));
				}
											
			} catch (Exception e){
				errors.add("fromDate", new ActionMessage("error.status.fromDate.wrong"));
			}
		}
		
		// of[ViItj
		if(toDate != null && !toDate.equals("")){	
			try{				
				DateFormat df = DateFormat.getDateInstance();
				df.setLenient(false);
				Date d = df.parse(toDate);
						
				if (d == null){
					errors.add("toDate", new ActionMessage("error.status.toDate.wrong"));
				}
											
			} catch (Exception e){
				errors.add("toDate", new ActionMessage("error.status.toDate.wrong"));
			}
		}
		return errors;

	}

	public String getSearchString(){
		String where = " where 1 = 1";
		
		if(!(id == null)){
			if(!id.equals("")){
				where += " and ";
				where += "SEQ_ID = '" + id + "'";
			}			
		}
		
		if(!(seiKanji == null)){
			if(!seiKanji.equals("")){
				where += " and ";
				where += "SEI_KANJI = '" + seiKanji + "'";
			}			
		}
		
		if(!(meiKanji == null)){
			if(!meiKanji.equals("")){
				where += " and ";
				where += "MEI_KANJI = '" + meiKanji + "'";
			}			
		}
		
		if(!(seiKana == null)){
			if(!seiKana.equals("")){
				where += " and ";
				where += "SEI_KANA = '" + seiKana + "'";
			}			
		}
		
		if(!(meiKana == null)){
			if(!meiKana.equals("")){
				where += " and ";
				where += "MEI_KANA = '" + meiKana + "'";
			}			
		}

		if(!(zip == null)){
			if(!zip.equals("")){
				where += " and ";
				where += "concat(ZIP1,ZIP2) = '" + zip + "'";
			}			
		}
		
		if(!(email == null)){
			if(!email.equals("")){
				where += " and ";
				where += "E_MAIL = '" + email + "'";
			}			
		}
		
		if(!(fromDate == null)){
			if(!fromDate.equals("")){
				where += " and ";
				where += "REQUEST_DATE > '" + fromDate + "'";
			}
		}
		
		if(!(toDate == null)){
			if(!toDate.equals("")){
				where += " and ";
				where += "REQUEST_DATE < '" + toDate + "'";
			}			
		}
		
		where += " and rownum <= " + viewCount;

		
		return where;
	}
	

}
