package jp.yoyoyoyo.webformmanager.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonUtil {
	
	// [AhXǂ肷
	public static boolean isMail(String value){
		Pattern pattern1 = Pattern.compile("[\\w\\.\\-]+@(?:[\\w\\-]+\\.)+[\\w\\-]+");
		Matcher matcher1 = pattern1.matcher(value);
		
		boolean ret =  matcher1.find();
		
		return ret;
	}
	
	// pǂ肷
	public static boolean isNumeric(String value){
		Pattern pattern1 = Pattern.compile("^[0-9]+$");
		Matcher matcher1 = pattern1.matcher(value);
		
		boolean ret =  matcher1.find();
		
		return ret;	
	}
	
	// SpJ^Jiǂ肷
	public static boolean isKatakana(String value){
		Pattern pattern1 = Pattern.compile("^[@-|[]+$");
		Matcher matcher1 = pattern1.matcher(value);
		
		boolean ret =  matcher1.find();
		
		return ret;	
	}
	
	//@@ˑ܂܂Ă邩ǂ肷
	public static boolean includeSpecialCharacter(String value){
		Pattern pattern1 = Pattern.compile("[@ABCDEFGHIJKLMNOPQRSTUVWX߇燓ہڇ恿~_opqrst_`abcdefghijklmnTUVWXYZ[\]]+");
		Matcher matcher1 = pattern1.matcher(value);
		
		boolean ret =  matcher1.find();
		
		return ret;	
	}
	
	// p܂܂Ă邩ǂ肷
	public static boolean includeHarfCharacter(String value){
		Pattern pattern1 = Pattern.compile("[ -~-]+");
		Matcher matcher1 = pattern1.matcher(value);
		
		boolean ret =  matcher1.find();
		
		return ret;	
	}
	
	// 	SpAt@xbg܂܂Ă邩ǂ肷
	public static boolean includeZenAlphabet(String value){
		Pattern pattern1 = Pattern.compile("[-`-y]+");
		Matcher matcher1 = pattern1.matcher(value);
		
		boolean ret =  matcher1.find();
		
		return ret;	
	}
	
	// 	Sp܂܂Ă邩ǂ肷
	public static boolean includeZenNumeric(String value){
		Pattern pattern1 = Pattern.compile("[O-X]+");
		Matcher matcher1 = pattern1.matcher(value);
		
		boolean ret =  matcher1.find();
		
		return ret;	
	}
	
	// [UIDǂ肷
	public static boolean isOperatorId(String value){
		Pattern pattern1 = Pattern.compile("^[0-9a-zA-Z]+$");
		Matcher matcher1 = pattern1.matcher(value);
		
		boolean ret =  matcher1.find();
		
		return ret;	
	}
	
	public static boolean validatePassword(String value){
		Pattern pattern1 =  Pattern.compile("^[0-9a-zA-Z]{6,20}$");
		Matcher matcher1 = pattern1.matcher(value);
		
		Pattern pattern2 =  Pattern.compile("[0-9]");
		Matcher matcher2 = pattern2.matcher(value);
		
		Pattern pattern3 =  Pattern.compile("[a-z]");
		Matcher matcher3 = pattern3.matcher(value);
		
		Pattern pattern4 =  Pattern.compile("[A-Z]");
		Matcher matcher4 = pattern4.matcher(value);
				
		boolean b1 = matcher1.find();
		boolean b2 = matcher2.find();
		boolean b3 = matcher3.find();
		boolean b4 = matcher4.find();	
		
		if(b1){
			if(b2 && b3 && b4){
				return true;
			}
		}
		
		return false;
	}
	
	public static String getMaskPassword(String value){
		int len = value.length();
		String ret = "";
		
		for(int i = 0; i < len; i++){
			ret += "*";
		}
		
		return ret;
		
	}
	
	public static String bytesToHexString(byte[] fromByte) { 
		StringBuilder hexStrBuilder = new StringBuilder();
		for (int i = 0; i < fromByte.length; i++) {
			// 16i\L1lꍇA2ڂ0Ŗ߂ 
			if ((fromByte[i] & 0xff) < 0x10) {
				hexStrBuilder.append("0");            
			}
			hexStrBuilder.append(Integer.toHexString(0xff & fromByte[i]));
		}
		
		return hexStrBuilder.toString();
	}
	
	public static byte[] HexStringToBytes(String fromHexStr) {
		//16i\Lł21oCg\邽߁A
		//Byte^zɕϊۂɂ́Az̒1/2ŗǂ
		byte[] toByte = new byte[fromHexStr.length() / 2];
		//16i\LA2Byte^֕ϊĂ 
		for (int i = 0; i < toByte.length; i++) {
			toByte[i] = (byte) Integer.parseInt(fromHexStr.substring(i * 2, (i + 1) * 2), 16);
			}        
		return toByte;    
	}
	

}
