﻿Public Class frmMain

    Private Sub btClose_Click(sender As System.Object, e As System.EventArgs) Handles btClose.Click
        Me.Close()
    End Sub

    Private Sub btConnectionTest_Click(sender As System.Object, e As System.EventArgs) Handles btConnectionTest.Click
        ' バリデーション
        If Not ValidateParameters() Then
            MsgBox("SQL Server Port以外必須項目です。", MsgBoxStyle.Information)
            Exit Sub
        End If

        ' DB Connectionテスト用フォームを開く
        Dim objTest As New frmTest
        objTest.tbConnectionString.Text = "Data Source=" & tbServerName.Text.Trim _
            & CStr(IIf(tbPort.Text.Trim = "", "", "," & tbPort.Text.Trim)) & ";" _
            & "Initial Catalog=" & tbDBName.Text.Trim & ";" _
            & "User ID=" & tbUserName.Text.Trim & ";" _
            & "Password=" & tbPassword.Text.Trim & ";" _
            & "Connect Timeout=5;"
        objTest.ShowDialog()
    End Sub

    ' バリデーション
    Private Function ValidateParameters() As Boolean
        If tbRegstryKey.Text.Trim = "" OrElse tbServerName.Text.Trim = "" _
            OrElse tbDBName.Text.Trim = "" OrElse tbUserName.Text.Trim = "" _
            OrElse tbPassword.Text.Trim = "" Then
            Return False
        Else
            Return True
        End If
    End Function

    Private Sub btProceed_Click(sender As System.Object, e As System.EventArgs) Handles btProceed.Click
        'バリデーション
        If Not ValidateParameters() Then
            MsgBox("SQL Server Port以外必須項目です。", MsgBoxStyle.Exclamation)
            Exit Sub
        End If

        ' データベース情報
        Dim DbInfo As New DBInfo(tbRegstryKey.Text.Trim, _
                                tbServerName.Text.Trim, _
                                tbPort.Text.Trim, _
                                tbDBName.Text.Trim, _
                                tbUserName.Text.Trim, _
                                tbPassword.Text.Trim)

        ' データベース情報確認フォームを開く
        Dim ConfirmForm As New frmConfirm()
        ConfirmForm.SetDBInfo(DbInfo)
        ConfirmForm.ShowDialog(Me)

    End Sub
End Class
