﻿Imports Microsoft.Win32

' データベース情報クラス
Public Class DBInfo
    '
    Public Const PrefixRegKey As String = "SOFTWARE\yoyoyoyo.jp\"
    Public ReadOnly RegKey As String    'HKEY_LOCAL_MACHINE\SOFTWARE\yoyoyoyo.jp からの相対パス
    Public ReadOnly Values As Hashtable

    ' コンストラクタ
    ' データベース情報クラスを初期化する
    Public Sub New(ByVal RegKey As String, _
                    ByVal DBServer As String, _
                    ByVal DBPort As String, _
                    ByVal DBInitialCatalog As String, _
                    ByVal DBUserID As String, _
                    ByVal DBPassword As String)

        Me.RegKey = RegKey
        Values = New Hashtable
        Values.Add("DBServer", DBServer)
        Values.Add("DBPort", DBPort)
        Values.Add("DBName", DBInitialCatalog)
        Values.Add("DBUser", DBUserID)

        'DB EncryptedPassword / SeedKey の生成
        Dim SeedKey As String = Crypt.CreateKey(256)
        Dim DBEncryptedSeedKey As String = SeedKey
        Dim DBEncryptedPassword As String = Crypt.EncryptTripleDES(SeedKey, DBPassword)

        Values.Add("DBEncryptedPassword", DBEncryptedPassword)
        Values.Add("DBEncryptedSeedKey", DBEncryptedSeedKey)
    End Sub

    '登録レジストリが存在するか
    Public Function existKey() As Boolean
        Return existRegKey(PrefixRegKey & RegKey)
    End Function

    'データベース情報をレジストリに保存する
    Public Sub Save()
        Dim Key As String
        For Each Key In Values.Keys
            setRegValue(PrefixRegKey & RegKey, Key, CStr(Values.Item(Key)))
        Next
    End Sub

    'レジストリの値を取得
    Public Shared Function getRegValue(ByVal RegKeyPath As String, ByVal Value As String) As String
        Dim RegKey As RegistryKey = Registry.LocalMachine.OpenSubKey(RegKeyPath, False)
        If RegKey Is Nothing Then
            Return ""
        Else
            Return RegKey.GetValue(Value, "").ToString
        End If
    End Function

    ' レジストリの更新
    Private Sub setRegValue(ByVal RegKeyPath As String, ByVal SubKey As String, ByVal Value As String)
        Dim RegKey As RegistryKey = Registry.LocalMachine.OpenSubKey(RegKeyPath, True)
        'Registry が存在しなければ、作成
        If RegKey Is Nothing Then
            RegKey = Registry.LocalMachine.CreateSubKey(RegKeyPath)
        End If
        RegKey.SetValue(SubKey, Value)
    End Sub

    'レジストリの存在確認
    Private Function existRegKey(ByVal RegKeyPath As String) As Boolean
        Dim RegKey As RegistryKey = Registry.LocalMachine.OpenSubKey(RegKeyPath, True)
        If RegKey Is Nothing Then
            Return False
        Else
            Return True
        End If
    End Function
End Class
