﻿Imports System.Data.Linq
Imports System.Drawing
Imports System.IO


<HandleError()> _
Public Class HomeController
    Inherits System.Web.Mvc.Controller

    Public Function watermark() As ActionResult
        Dim bmp As New Bitmap(100, 20)
        Dim g As Graphics = Graphics.FromImage(bmp)
        Dim fnt As New Font("MS UI Gothic", 16, FontStyle.Bold)
        g.Clear(Color.White)
        g.DrawString(Session("WaterMarkNo"), fnt, Brushes.Orange, 0, 0)
        Response.ContentType = "image/jpeg"
        Dim mem = New MemoryStream()
        bmp.Save(mem, System.Drawing.Imaging.ImageFormat.Jpeg)
        mem.Seek(0, SeekOrigin.Begin)
        Return New FileStreamResult(mem, "image/jpeg")
    End Function

    Function Entry() As ActionResult
        Response.CacheControl = "no-cache"
        ' テスト用ボタンの表示
        If Util.GetAppSetting("TEST_MODE").ToUpper = "ON" Then
            ViewData("testdata") = "<input type=""submit"" name=""button"" value=""Test Data"" />"
        Else
            ViewData("testdata") = ""
        End If

        ' 入力情報オブジェクトの取得
        Dim objEntry As EntryData = TryCast(Session("EntryData"), EntryData)

        ' 画像認証コードの番号生成
        If Session("WaterMarkNo") Is Nothing Then
            Dim r As New System.Random()
            Session("WaterMarkNo") = r.Next(10000, 99999).ToString
        End If

        ' 画像認証コードのURL設定
        ViewData("watermarkUrl") = "../Home/watermark?s=" & DateTime.Now.Ticks

        ' 画像認証コードのカウンタ初期化
        If Session("WartermarkErrorCount") Is Nothing Then
            Session("WartermarkErrorCount") = 0
        End If

        ' 職業用プルダウンメニューの生成
        Dim items As List(Of SelectListItem) = New List(Of SelectListItem)()
        Util.AddListItem(items, "2")

        Dim occupation As SelectList

        If Not objEntry Is Nothing AndAlso objEntry.IsBack = True Then
            occupation = New SelectList(items, "Value", "Text", objEntry.OCCUPATION)
        Else
            occupation = New SelectList(items, "Value", "Text")
        End If
        ViewData("occupation") = occupation

        ' 性別用ラジオボタンの生成
        Dim gender As List(Of SelectListItem) = New List(Of SelectListItem)
        Util.AddListItem(gender, "1")

        If Not objEntry Is Nothing AndAlso objEntry.IsBack = True Then
            For Each item As SelectListItem In gender
                If item.Value = objEntry.GENDER Then
                    item.Selected = True
                    Exit For
                End If
            Next
        End If

        ' 入力情報オブジェクトにデータが存在し、確認画面からの戻りのとき値をセットする
        ' もしくはバリデーションエラーになったとき値をセットしなおす
        If Not objEntry Is Nothing AndAlso objEntry.IsBack = True Then

            ViewData("kanji_sei_value") = objEntry.KANJI_SEI
            ViewData("kanji_mei_value") = objEntry.KANJI_MEI
            ViewData("kana_sei_value") = objEntry.KANA_SEI
            ViewData("kana_mei_value") = objEntry.KANA_MEI
            ViewData("birth_year_value") = objEntry.BIRTH_DATE_YEAR
            ViewData("birth_month_value") = objEntry.BIRTH_DATE_MONTH
            ViewData("birth_day_value") = objEntry.BIRTH_DATE_DAY
            ViewData("zip1_value") = objEntry.ZIP1
            ViewData("zip2_value") = objEntry.ZIP2
            ViewData("address1_value") = objEntry.ADDRESS1
            ViewData("address2_value") = objEntry.ADDRESS2
            ViewData("address3_value") = objEntry.ADDRESS3
            ViewData("address4_value") = objEntry.ADDRESS4
            ViewData("tel1_value") = objEntry.TEL1
            ViewData("tel2_value") = objEntry.TEL2
            ViewData("tel3_value") = objEntry.TEL3
            ViewData("m_tel1_value") = objEntry.M_TEL1
            ViewData("m_tel2_value") = objEntry.M_TEL2
            ViewData("m_tel3_value") = objEntry.M_TEL3
            ViewData("e_mail_value") = objEntry.E_MAIL
            ViewData("e_mail2_value") = objEntry.E_MAIL2
            ViewData("watermark_value") = objEntry.WatermarkNo
        End If

        Return View(gender)
    End Function

    <HttpPost()> _
    Function Entry(ByVal collection As FormCollection) As ActionResult
        Dim objEntry As EntryData = New EntryData

        If collection.Item("button") = "次へ" Then    ' 次へボタンを押したとき
            If Session("WartermarkErrorCount") Is Nothing AndAlso Not objEntry Is Nothing AndAlso objEntry.IsBack = True Then
                Session("WartermarkErrorCount") = 0
            End If

            ' Postされたデータをオブジェクトに格納
            objEntry.KANJI_SEI = collection.Item("kanji_sei").Trim
            objEntry.KANJI_MEI = collection.Item("kanji_mei").Trim
            objEntry.KANA_SEI = collection.Item("kana_sei").Trim
            objEntry.KANA_MEI = collection.Item("kana_mei").Trim
            objEntry.BIRTH_DATE_YEAR = collection.Item("birth_year").Trim
            objEntry.BIRTH_DATE_MONTH = collection.Item("birth_month").Trim
            objEntry.BIRTH_DATE_DAY = collection.Item("birth_day").Trim
            objEntry.GENDER = IIf(collection.Item("gender") Is Nothing, Nothing, CInt(collection.Item("gender")))
            objEntry.GENDER_TEXT = Util.GetDataName("1", collection.Item("gender"))
            objEntry.ZIP1 = collection.Item("zip1").Trim
            objEntry.ZIP2 = collection.Item("zip2").Trim
            objEntry.ADDRESS1 = collection.Item("address1").Trim
            objEntry.ADDRESS2 = collection.Item("address2").Trim
            objEntry.ADDRESS3 = collection.Item("address3").Trim
            objEntry.ADDRESS4 = collection.Item("address4").Trim
            objEntry.TEL1 = collection.Item("tel1").Trim
            objEntry.TEL2 = collection.Item("tel2").Trim
            objEntry.TEL3 = collection.Item("tel3").Trim
            objEntry.M_TEL1 = collection.Item("m_tel1").Trim
            objEntry.M_TEL2 = collection.Item("m_tel2").Trim
            objEntry.M_TEL3 = collection.Item("m_tel3").Trim
            objEntry.E_MAIL = collection.Item("e_mail").Trim
            objEntry.E_MAIL2 = collection.Item("e_mail2").Trim
            objEntry.OCCUPATION = collection.Item("occupation")
            objEntry.OCCUPATION_TEXT = Util.GetDataName("2", collection.Item("occupation"))
            objEntry.IP_ADDRESS = System.Web.HttpContext.Current.Request.UserHostAddress
            objEntry.SESSION_ID = Session.SessionID

            objEntry.IsBack = True

            ' オブジェクトをセッションに格納
            Session("EntryData") = objEntry

            ' バリデーション処理を呼び出す
            ValidateProc(objEntry)

            ' 画像認証のバリデーション処理を行う
            If collection.Item("watermark") = "" Then
                ModelState.AddModelError("", "画像認証コードを入力してください")
            ElseIf collection.Item("watermark") <> Session("WaterMarkNo") Then
                ModelState.AddModelError("", "画像認証コードが間違っています")
                Session("WartermarkErrorCount") = Session("WartermarkErrorCount") + 1
                If Session("WartermarkErrorCount") >= 5 Then
                    Return RedirectToAction("WatermarkError", "Home")
                End If
            End If

            ' バリデーションエラーが発生したとき再表示を行う
            If Not ModelState.IsValid Then
                Return Entry()
            End If

            objEntry.IsBack = False

            Session(ScreenDefine.sessionID_PID) = ScreenDefine.pageId_Confirm

            Session("WartermarkErrorCount") = 0
            ' 確認画面へ遷移する
            Return RedirectToAction("Confirm", "Home")
        Else    ' Test Dataボタンを押したとき
            ' テストデータをセットする
            objEntry.KANJI_SEI = "山田"
            objEntry.KANJI_MEI = "太郎"
            objEntry.KANA_SEI = "ヤマダ"
            objEntry.KANA_MEI = "タロウ"
            objEntry.BIRTH_DATE_YEAR = "1975"
            objEntry.BIRTH_DATE_MONTH = "1"
            objEntry.BIRTH_DATE_DAY = "1"
            objEntry.GENDER = 1
            objEntry.GENDER_TEXT = Util.GetDataName("1", 1)
            objEntry.ZIP1 = "100"
            objEntry.ZIP2 = "0001"
            objEntry.ADDRESS1 = "東京都"
            objEntry.ADDRESS2 = "千代田区"
            objEntry.ADDRESS3 = "千代田１－２－３"
            objEntry.ADDRESS4 = "マンション１０１"
            objEntry.TEL1 = "03"
            objEntry.TEL2 = "1234"
            objEntry.TEL3 = "5678"
            objEntry.M_TEL1 = "090"
            objEntry.M_TEL2 = "1234"
            objEntry.M_TEL3 = "5678"
            objEntry.E_MAIL = "a@yoyoyoyo.jp"
            objEntry.E_MAIL2 = "a@yoyoyoyo.jp"
            objEntry.OCCUPATION = 1
            objEntry.OCCUPATION_TEXT = Util.GetDataName("2", 1)

            objEntry.WatermarkNo = Session("WaterMarkNo")

            objEntry.IsBack = True

            Session("EntryData") = objEntry
            Return Entry()
        End If

    End Function

    ' バリデーション処理用関数
    Private Sub ValidateProc(ByVal obj As EntryData)
        Dim IsValidForZip1 As Boolean = True
        Dim IsValidForZip2 As Boolean = True

        ' 姓（漢字）の判定
        If obj.KANJI_SEI = "" Then
            ModelState.AddModelError("", "姓（漢字）は必須です")
        End If

        If obj.KANJI_SEI.Length > 20 Then
            ModelState.AddModelError("", "姓（漢字）は２０文字以内で入力してください")
        End If

        If Util.IncludeHarfCharacter(obj.KANJI_SEI) Then
            ModelState.AddModelError("", "姓（漢字）に半角文字は使えません")
        End If

        If Util.IncludeZenAlphabet(obj.KANJI_SEI) Then
            ModelState.AddModelError("", "姓（漢字）に全角アルファベットは使えません")
        End If

        If Util.IncludeZenNumeric(obj.KANJI_SEI) Then
            ModelState.AddModelError("", "姓（漢字）に全角数字は使えません")
        End If

        If Util.IncludeSpecialCharacter(obj.KANJI_SEI) Then
            ModelState.AddModelError("", "姓（漢字）に機種依存文字は使えません")
        End If

        ' 名（漢字）の判定
        If obj.KANJI_MEI = "" Then
            ModelState.AddModelError("", "名（漢字）は必須です")
        End If

        If obj.KANJI_MEI.Length > 20 Then
            ModelState.AddModelError("", "名（漢字）は２０文字以内で入力してください")
        End If

        If Util.IncludeHarfCharacter(obj.KANJI_MEI) Then
            ModelState.AddModelError("", "名（漢字）に半角文字は使えません")
        End If

        If Util.IncludeZenAlphabet(obj.KANJI_MEI) Then
            ModelState.AddModelError("", "名（漢字）に全角アルファベットは使えません")
        End If

        If Util.IncludeZenNumeric(obj.KANJI_MEI) Then
            ModelState.AddModelError("", "名（漢字）に全角数字は使えません")
        End If

        If Util.IncludeSpecialCharacter(obj.KANJI_MEI) Then
            ModelState.AddModelError("", "名（漢字）に機種依存文字は使えません")
        End If

        ' 姓（カナ）の判定
        If obj.KANA_SEI = "" Then
            ModelState.AddModelError("", "姓（カナ）は必須です")
        End If

        If obj.KANA_SEI.Length > 20 Then
            ModelState.AddModelError("", "姓（カナ）は２０文字以内で入力してください")
        End If

        If Not Util.IsKatakana(obj.KANA_SEI) Then
            ModelState.AddModelError("", "姓（カナ）はカタカナで入力してください")
        End If

        ' 名（カナ）の判定
        If obj.KANA_MEI = "" Then
            ModelState.AddModelError("", "名（カナ）は必須です")
        End If

        If obj.KANA_MEI.Length > 20 Then
            ModelState.AddModelError("", "名（カナ）は２０文字以内で入力してください")
        End If

        If Not Util.IsKatakana(obj.KANA_MEI) Then
            ModelState.AddModelError("", "名（カナ）はカタカナで入力してください")
        End If

        ' 生年月日の判定
        If Not IsDate(obj.BIRTH_DATE_YEAR & "/" & obj.BIRTH_DATE_MONTH & "/" & obj.BIRTH_DATE_DAY) Then
            ModelState.AddModelError("", "有効な生年月日でありません")
        End If

        ' 性別の判定
        If obj.GENDER Is Nothing Then
            ModelState.AddModelError("", "性別を選択してください")
        End If

        ' 郵便番号の判定
        If obj.ZIP1.Length <> 3 Then
            ModelState.AddModelError("", "郵便番号(前半３桁)は３桁の数字で入力してください")
            IsValidForZip1 = False
        End If

        If IsValidForZip1 AndAlso Not Util.IsNumeric(obj.ZIP1) Then
            ModelState.AddModelError("", "郵便番号(前半３桁)は３桁の数字で入力してください")
        End If

        If obj.ZIP2.Length <> 4 Then
            ModelState.AddModelError("", "郵便番号(後半４桁)は４桁の数字で入力してください")
            IsValidForZip2 = False
        End If

        If IsValidForZip2 AndAlso Not Util.IsNumeric(obj.ZIP2) Then
            ModelState.AddModelError("", "郵便番号(後半４桁)は４桁の数字で入力してください")
        End If

        ' 住所の判定
        If obj.ADDRESS1 = "" Then
            ModelState.AddModelError("", "都道府県を入力してください")
        End If

        If Util.IncludeHarfCharacter(obj.ADDRESS1) Then
            ModelState.AddModelError("", "都道府県に半角文字は使えません")
        End If

        If Util.IncludeSpecialCharacter(obj.ADDRESS1) Then
            ModelState.AddModelError("", "都道府県に機種依存文字は使えません")
        End If


        If obj.ADDRESS1.Length > 30 Then
            ModelState.AddModelError("", "都道府県は３０文字以内で入力してください")
        End If

        If obj.ADDRESS2 = "" Then
            ModelState.AddModelError("", "市区郡を入力してください")
        End If

        If Util.IncludeHarfCharacter(obj.ADDRESS2) Then
            ModelState.AddModelError("", "市区郡に半角文字は使えません")
        End If

        If Util.IncludeSpecialCharacter(obj.ADDRESS2) Then
            ModelState.AddModelError("", "市区郡に機種依存文字は使えません")
        End If

        If obj.ADDRESS2.Length > 30 Then
            ModelState.AddModelError("", "市区郡は３０文字以内で入力してください")
        End If

        If obj.ADDRESS3 = "" Then
            ModelState.AddModelError("", "町名・番地を入力してください")
        End If

        If Util.IncludeHarfCharacter(obj.ADDRESS3) Then
            ModelState.AddModelError("", "町名・番地に半角文字は使えません")
        End If

        If Util.IncludeSpecialCharacter(obj.ADDRESS3) Then
            ModelState.AddModelError("", "町名・番地に機種依存文字は使えません")
        End If


        If obj.ADDRESS3.Length > 40 Then
            ModelState.AddModelError("", "町名・番地は３０文字以内で入力してください")
        End If

        If Util.IncludeHarfCharacter(obj.ADDRESS4) Then
            ModelState.AddModelError("", "マンション・アパート名に半角文字は使えません")
        End If

        If Util.IncludeSpecialCharacter(obj.ADDRESS4) Then
            ModelState.AddModelError("", "マンション・アパート名に機種依存文字は使えません")
        End If

        If obj.ADDRESS4.Length > 40 Then
            ModelState.AddModelError("", "マンション・アパート名は４０文字以内で入力してください")
        End If

        ' 電話番号の判定
        If obj.TEL1 = "" AndAlso obj.TEL2 = "" AndAlso obj.TEL3 = "" AndAlso
            obj.M_TEL1 = "" AndAlso obj.M_TEL2 = "" AndAlso obj.M_TEL3 = "" Then
            ModelState.AddModelError("", "自宅電話番号か携帯電話番号を入力してください")
        End If

        If obj.TEL1 <> "" OrElse obj.TEL2 <> "" OrElse obj.TEL3 <> "" Then
            If obj.TEL1.Length > 6 Then
                ModelState.AddModelError("", "自宅電話番号（市外局番）は６桁以内で入力してください")
            End If

            If obj.TEL2.Length > 5 Then
                ModelState.AddModelError("", "自宅電話番号（局番）は５桁以内で入力してください")
            End If

            If obj.TEL3 <> "" AndAlso obj.TEL3.Length <> 4 Then
                ModelState.AddModelError("", "自宅電話番号（枝番）は４桁で入力してください")
            End If

            If obj.TEL1 = "" Then
                ModelState.AddModelError("", "自宅電話番号（市外局番）を入力してください")
            End If
            If obj.TEL2 = "" Then
                ModelState.AddModelError("", "自宅電話番号（局番）を入力してください")
            End If
            If obj.TEL3 = "" Then
                ModelState.AddModelError("", "自宅電話番号（枝番）を入力してください")
            End If

            If Not Util.IsNumeric(obj.TEL1) Then
                ModelState.AddModelError("", "自宅電話番号（市外局番）は数字で入力してください")
            End If

            If Not Util.IsNumeric(obj.TEL2) Then
                ModelState.AddModelError("", "自宅電話番号（局番）は数字で入力してください")
            End If

            If Not Util.IsNumeric(obj.TEL3) Then
                ModelState.AddModelError("", "自宅電話番号（枝番）は数字で入力してください")
            End If
        End If

        If obj.M_TEL1 <> "" OrElse obj.M_TEL2 <> "" OrElse obj.M_TEL3 <> "" Then
            If obj.M_TEL1 <> "" AndAlso obj.M_TEL1.Length <> 3 Then
                ModelState.AddModelError("", "携帯電話番号（先頭３桁）は３桁で入力してください")
            End If

            If obj.M_TEL2 <> "" AndAlso obj.M_TEL2.Length <> 4 Then
                ModelState.AddModelError("", "携帯電話番号（中央４桁）は４桁で入力してください")
            End If

            If obj.M_TEL3 <> "" AndAlso obj.M_TEL3.Length <> 4 Then
                ModelState.AddModelError("", "携帯電話番号（末尾４桁）は４桁で入力してください")
            End If

            If obj.M_TEL1 = "" Then
                ModelState.AddModelError("", "携帯電話番号（先頭３桁）を入力してください")
            End If
            If obj.M_TEL2 = "" Then
                ModelState.AddModelError("", "携帯電話番号（中央４桁）を入力してください")
            End If
            If obj.M_TEL3 = "" Then
                ModelState.AddModelError("", "携帯電話番号（末尾４桁）を入力してください")
            End If

            If Not Util.IsNumeric(obj.M_TEL1) Then
                ModelState.AddModelError("", "携帯電話番号（先頭３桁）は数字で入力してください")
            End If

            If Not Util.IsNumeric(obj.M_TEL2) Then
                ModelState.AddModelError("", "携帯電話番号（中央４桁）は数字で入力してください")
            End If

            If Not Util.IsNumeric(obj.M_TEL3) Then
                ModelState.AddModelError("", "携帯電話番号（末尾４桁）は数字で入力してください")
            End If

        End If

        ' メールアドレスの判定
        If obj.E_MAIL = "" Then
            ModelState.AddModelError("", "メールアドレスを入力してください")
        End If

        If obj.E_MAIL.Length > 50 Then
            ModelState.AddModelError("", "メールアドレスは５０文字以内で入力してください")
        End If

        If obj.E_MAIL.Length > 0 Then
            If Not Util.IsMail(obj.E_MAIL) Then
                ModelState.AddModelError("", "正しいメールアドレスを入力してください")
            ElseIf obj.E_MAIL <> obj.E_MAIL2 Then
                ModelState.AddModelError("", "メールアドレス（確認）が間違っています")
            End If
        End If

        ' 職業の判定
        If obj.OCCUPATION = 0 Then
            ModelState.AddModelError("", "職業を選択してください")
        End If

 
    End Sub


    Function Confirm() As ActionResult


        Response.CacheControl = "no-cache"

        If Session(ScreenDefine.sessionID_PID) <> ScreenDefine.pageId_Confirm Then
            Return RedirectToAction("Entry", "Home")
        End If

        ' 入力情報オブジェクトの取得
        Dim objEntry As EntryData = TryCast(Session("EntryData"), EntryData)

        ' 表示データの設定
        ViewData("kanji_sei") = Util.GetHtmlEncode(objEntry.KANJI_SEI)
        ViewData("kanji_mei") = Util.GetHtmlEncode(objEntry.KANJI_MEI)
        ViewData("kana_sei") = Util.GetHtmlEncode(objEntry.KANA_SEI)
        ViewData("kana_mei") = Util.GetHtmlEncode(objEntry.KANA_MEI)
        ViewData("birth_year") = Util.GetHtmlEncode(objEntry.BIRTH_DATE_YEAR)
        ViewData("birth_month") = Util.GetHtmlEncode(objEntry.BIRTH_DATE_MONTH)
        ViewData("birth_day") = Util.GetHtmlEncode(objEntry.BIRTH_DATE_DAY)
        ViewData("gender") = Util.GetHtmlEncode(objEntry.GENDER_TEXT)
        ViewData("zip1") = Util.GetHtmlEncode(objEntry.ZIP1)
        ViewData("zip2") = Util.GetHtmlEncode(objEntry.ZIP2)
        ViewData("address1") = Util.GetHtmlEncode(objEntry.ADDRESS1)
        ViewData("address2") = Util.GetHtmlEncode(objEntry.ADDRESS2)
        ViewData("address3") = Util.GetHtmlEncode(objEntry.ADDRESS3)
        ViewData("address4") = Util.GetHtmlEncode(objEntry.ADDRESS4)
        ViewData("tel") = Util.GetHtmlEncode(objEntry.TEL1) & "-" & Util.GetHtmlEncode(objEntry.TEL2) & "-" & Util.GetHtmlEncode(objEntry.TEL3)
        ViewData("m_tel") = Util.GetHtmlEncode(objEntry.M_TEL1) & "-" & Util.GetHtmlEncode(objEntry.M_TEL2) & "-" & Util.GetHtmlEncode(objEntry.M_TEL3)
        ViewData("e_mail") = Util.GetHtmlEncode(objEntry.E_MAIL)
        ViewData("occupation") = Util.GetHtmlEncode(objEntry.OCCUPATION_TEXT)

        Return View()
    End Function

    <HttpPost()>
    Function Confirm(ByVal collection As FormCollection) As ActionResult
        Dim objEntry As EntryData = TryCast(Session("EntryData"), EntryData)

        If collection.Item("button") = "次へ" Then    ' 次へボタンを押したとき
            'データベースに書き込む
            Dim connStr As String = Util.GetConnectionString
            Dim dc As WebFormDBDataContext = New WebFormDBDataContext(connStr)
            Try
                dc.insertRequest(objEntry.SEQ_ID,
                                  objEntry.KANJI_SEI,
                                  objEntry.KANJI_MEI,
                                  objEntry.KANA_SEI,
                                  objEntry.KANA_MEI,
                                  String.Format("{0:0000}", CInt(objEntry.BIRTH_DATE_YEAR)) & String.Format("{0:00}", CInt(objEntry.BIRTH_DATE_MONTH)) & String.Format("{0:00}", CInt(objEntry.BIRTH_DATE_DAY)),
                                  objEntry.GENDER,
                                  objEntry.GENDER_TEXT,
                                  objEntry.ZIP1,
                                  objEntry.ZIP2,
                                  objEntry.ADDRESS1,
                                  objEntry.ADDRESS2,
                                  objEntry.ADDRESS3,
                                  objEntry.ADDRESS4,
                                  objEntry.TEL1,
                                  objEntry.TEL2,
                                  objEntry.TEL3,
                                  objEntry.M_TEL1,
                                  objEntry.M_TEL2,
                                  objEntry.M_TEL3,
                                  objEntry.E_MAIL,
                                  objEntry.OCCUPATION,
                                  objEntry.OCCUPATION_TEXT,
                                  objEntry.IP_ADDRESS,
                                  objEntry.SESSION_ID)

                dc.SubmitChanges()
            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try

            Session(ScreenDefine.sessionID_PID) = ScreenDefine.pageId_Thankyou
            ' Thankyou画面に遷移   
            Return RedirectToAction("Thankyou", "Home")
        Else    '"戻る" ボタンををしたとき
            objEntry.IsBack = True
            Session("EntryData") = objEntry
            Session(ScreenDefine.sessionID_PID) = ScreenDefine.pageId_Entry
            ' 入力画面に遷移   
            Return RedirectToAction("Entry", "Home")
        End If
    End Function

    Function Thankyou() As ActionResult


        Response.CacheControl = "no-cache"

        If Session(ScreenDefine.sessionID_PID) <> ScreenDefine.pageId_Thankyou Then
            Return RedirectToAction("Entry", "Home")
        End If

        Dim objEntry As EntryData = TryCast(Session("EntryData"), EntryData)

        ViewData("RequestNo") = String.Format("{0:0000000000}", objEntry.SEQ_ID)

        Session.Clear()

        Return View()
    End Function

    Function Maintenance() As ActionResult
        Session.Clear()
        Return View()
    End Function

    Function WatermarkError() As ActionResult
        Return View()
    End Function
End Class
