﻿Namespace WebForm
    Public Class PostalController
        Inherits System.Web.Mvc.Controller

        Function Postal(ByVal id As String) As ActionResult
            Dim Path As String = Util.GetAppSetting("DataPostalXML")
            Dim FullPath As String = System.Web.HttpContext.Current.Server.MapPath(Path)
            Dim xmldoc As XElement = XElement.Load(FullPath)
            Dim query As IEnumerable(Of XElement) = From x In xmldoc.Descendants("address") Where x.Element("postalcode").Value = id

            Dim address1 As String = query.Elements("address1").Value
            Dim address2 As String = query.Elements("address2").Value
            Dim address3 As String = query.Elements("address3").Value

            ViewData("postal_address1_value") = address1
            ViewData("postal_address2_value") = address2
            ViewData("postal_address3_value") = address3

            Return View()
        End Function

    End Class
End Namespace