﻿var user_agent;
var is_safari;
var is_mac;
var is_firefox;
var is_chrome;

var lastkey = '';

user_agent = navigator.userAgent;
is_safari = (user_agent.toLowerCase().indexOf('safari') != -1);
is_mac = (user_agent.toLowerCase().indexOf("mac") != -1);
is_firefox = (user_agent.toLowerCase().indexOf("firefox") != -1);
is_chrome = (user_agent.toLowerCase().indexOf("chrome") != -1);

function isNetscape() {
    return (navigator.appName == "Netscape");
}

// キー操作、右クリック無効化スクリプト
function disableKeysAndContextMenu() {
    if (is_mac) {
        if (is_chrome) {
            document.oncontextmenu = disableContext;
            document.onkeydown = disableMacSafariKeys;
        } else if (is_safari) {
            document.oncontextmenu = disableContext;
            document.onkeydown = disableMacSafariKeys;
        } else if (is_firefox) {
            document.oncontextmenu = disableContext;
            document.onkeypress = disableMacFirefoxKeys;
        } else if (isNetscape()) {
            document.oncontextmenu = disableContext;
            document.onkeypress = disableMacNetscapeKeys;
        }
    } else {
        if (is_chrome) {
            document.oncontextmenu = disableContext;
            document.onkeydown = disableFirefoxKeys;
        } else if (is_safari) {
            document.oncontextmenu = disableContext;
            document.onkeydown = disableSafariKeys;
        } else if (is_firefox) {
            document.oncontextmenu = disableContext;
            document.onkeypress = disableFirefoxKeys;
        } else if (isNetscape()) {
            document.oncontextmenu = disableContext;
            document.onkeypress = disableNetscapeKeys;
        } else {
            document.oncontextmenu = disableContextIE;
            document.onkeydown = disableIEKeys;
        }
    }
}

function checkKeyDown(e) {
    var ch3 = 0;
    ch3 = (e.keyCode) ? e.keyCode : (e.charCode) ? e.charCode : e.which;
    {
        if (ch3 == 16) { lastkey = 'SHIFT-'; }
        else if (ch3 == 17) { lastkey = 'CTRL-'; }
        else if (ch3 == 18) { lastkey = 'ALT-'; }
    }
}

function checkKeyDownMac(e) {
    var ch3 = 0;
    ch3 = (e.keyCode) ? e.keyCode : (e.charCode) ? e.charCode : e.which;
    {
        if (ch3 == 16) { lastkey = 'SHIFT-'; }
        else if (ch3 == 17) { lastkey = 'CTRL-'; }
        else if (ch3 == 18) { lastkey = 'OPTION-'; }
        else if (ch3 == 224) { lastkey = 'COMMAND-'; }
    }
}

function disableIEKeys() {
    /*
    * Escの抑制
    */
    if (event.keyCode == 27) {
        event.keyCode = 0;
        event.returnValue = false;
        return;
    }
    /*
    * Alt_Home, Alt_->, Alt_<-, Alt_Back Spaceの抑制
    */
    if (event.altKey) {
        if (event.keyCode == 36
			|| event.keyCode == 37
			|| event.keyCode == 39
			|| event.keyCode == 8) {
            event.returnValue = false;
            return;
        }
    }
    /*
    * Ctrl+下記キーの抑制
    * Tab,B,D,E,F,H,I,L,N,O,R,W
    */
    if (event.ctrlKey) {
        if (event.keyCode == 9
			|| event.keyCode == 66
			|| event.keyCode == 68
			|| event.keyCode == 69
			|| event.keyCode == 70
			|| event.keyCode == 72
			|| event.keyCode == 73
			|| event.keyCode == 76
			|| event.keyCode == 78
			|| event.keyCode == 79
			|| event.keyCode == 82
			|| event.keyCode == 87) {
            event.keyCode = 0;
            event.returnValue = false;
            return;
        }
    }
    /*
    * BackSpaceの抑制
    */
    if (event.keyCode == 8) {
        if ((event.srcElement.tagName == "TEXTAREA") ||
				(event.srcElement.tagName == "INPUT" &&
				(event.srcElement.type == "text"
			|| event.srcElement.type == "password"
			|| event.srcElement.type == "file"))) {
            return;
        }
        event.keyCode = 0;
        event.returnValue = false;
        return;
    }
    /*
    *  F1～F12(112～123)の抑制
    */
    if (event.keyCode >= 112 && event.keyCode <= 123) {
        event.keyCode = 0;        /* キー入力を無効にする */
        event.returnValue = false;
        return;
    }
}

function disableNetscapeKeys(e) {
    ctrl = typeof e.modifiers == 'undefined' ? e.ctrlKey : e.modifiers & Event.CONTROL_MASK
    shift = typeof e.modifiers == 'undefined' ? e.shiftKey : e.modifiers & Event.SHIFT_MASK;
    alt = typeof e.modifiers == 'undefined' ? e.altKey : e.modifiers & Event.ALT_MASK;

    ch = (e.keyCode) ? e.keyCode : (e.charCode) ? e.charCode : e.which;
    /*
    * Escの抑制
    */
    if (e.keyCode == 27) {
        DisableKey(e);
        return;
    }
    /*
    * Alt_Home, Alt_->, Alt_<-, Alt_Back Spaceの抑制
    */
    if (lastkey == 'ALT-') {
        if (e.keyCode == 36
			|| e.keyCode == 37
			|| e.keyCode == 39
			|| e.keyCode == 8) {
            DisableKey(e);
            return;
        }
    }
    /*
    * Ctrl+下記キーの抑制
    * Tab,B,D,E,F,H,I,L,N,O,R,W
    */
    if (lastkey == 'CTRL-') {
        if (e.keyCode == 0 && (
			   ch == 98
			|| ch == 100
			|| ch == 101
			|| ch == 102
			|| ch == 104
			|| ch == 105
			|| ch == 108
			|| ch == 110
			|| ch == 111
			|| ch == 114
			|| ch == 119)) {
            DisableKey(e);
            return;
        } else if (e.keyCode == 9) {
            DisableKey(e);
            return;
        }
    }
    /*
    * BackSpaceの抑制
    */
    if (e.keyCode == 8) {
        if ((e.target.tagName == "TEXTAREA") ||
				(e.target.tagName == "INPUT" &&
				(e.target.type == "text"
			|| e.target.type == "password"
			|| e.target.type == "file"))) {
            lastkey = "";
            return;
        }
        DisableKey(e);
        return;
    }
    /*
    *  F1～F12(112～123)の抑制
    */
    if (e.keyCode >= 112 && e.keyCode <= 123) {
        DisableKey(e);
        return;
    }

    lastkey = "";

}

function disableFirefoxKeys(e) {
    var ctrl = typeof e.modifiers == 'undefined' ? e.ctrlKey : e.modifiers & Event.CONTROL_MASK
    var shift = typeof e.modifiers == 'undefined' ? e.shiftKey : e.modifiers & Event.SHIFT_MASK;
    var alt = typeof e.modifiers == 'undefined' ? e.altKey : e.modifiers & Event.ALT_MASK;

    ch = (e.keyCode) ? e.keyCode : (e.charCode) ? e.charCode : e.which;
    /*
    * Escの抑制
    */
    if (e.keyCode == 27) {
        DisableKey(e);
        return;
    }
    /*
    * Alt_Home, Alt_->, Alt_<-, Alt_Back Spaceの抑制
    */
    if (alt) {
        if (e.keyCode == 36
			|| e.keyCode == 37
			|| e.keyCode == 39
			|| e.keyCode == 8) {
            DisableKey(e);
            return;
        }
    }
    /*
    * Ctrl+下記キーの抑制
    * Tab,B,D,E,F,H,I,L,N,O,R,W
    */
    if (ctrl) {
        if (e.keyCode == 0 && (
			   ch == 98
			|| ch == 100
			|| ch == 101
			|| ch == 102
			|| ch == 104
			|| ch == 105
			|| ch == 108
			|| ch == 110
			|| ch == 111
			|| ch == 114
			|| ch == 119)) {
            DisableKey(e);
            return;
        } else if (e.keyCode == 9) {
            DisableKey(e);
            return;
        }
    }
    /*
    * BackSpaceの抑制
    */
    if (e.keyCode == 8) {
        if ((e.target.tagName == "TEXTAREA") ||
				(e.target.tagName == "INPUT" &&
				(e.target.type == "text"
			|| e.target.type == "password"
			|| e.target.type == "file"))) {
            lastkey = "";
            return;
        }
        DisableKey(e);
        return;
    }
    /*
    *  F1～F12(112～123)の抑制
    */
    if (e.keyCode >= 112 && e.keyCode <= 123) {
        DisableKey(e);
        return;
    }

    lastkey = "";

}

function disableMacNetscapeKeys(e) {
    ch = (e.keyCode) ? e.keyCode : (e.charCode) ? e.charCode : e.which;

    /*
    * Escの抑制
    */
    if (e.keyCode == 27) {
        DisableKey(e);
        return;
    }
    /*
    * Cmdの抑制
    * ->,<-,Delete,N,O,L,D,R,T,[,]
    */
    if (lastkey == 'COMMAND-') {
        if (e.keyCode == 37
			|| e.keyCode == 39
			|| e.keyCode == 8
			|| (e.keyCode == 0 &&
			   (ch == 110 || ch == 111 || ch == 108 || ch == 100 || ch == 114 || ch == 116 || ch == 91 || ch == 93))) {
            DisableKey(e);
            return;
        }
    }

    /*
    * Option_Home
    */
    if (lastkey == 'OPTION-') {
        if (e.keyCode == 36) {
            DisableKey(e);
            return;
        }
    }

    if (lastkey == 'SHIFT-') {
        if (e.keyCode == 8) {
            DisableKey(e);
            return;
        }
    }

    /*
    * BackSpaceの抑制
    */
    if (e.keyCode == 8) {
        if ((e.target.tagName == "TEXTAREA") ||
				(e.target.tagName == "INPUT" &&
				(e.target.type == "text"
			|| e.target.type == "password"
			|| e.target.type == "file"))) {
            lastkey = "";
            return;
        }
        DisableKey(e);
        return;
    }
    /*
    *  F1～F12(112～123)の抑制
    */
    if (e.keyCode >= 112 && e.keyCode <= 123) {
        DisableKey(e);
        return;
    }

    lastkey = "";

}

function disableMacFirefoxKeys(e) {
    var ch = (e.keyCode) ? e.keyCode : (e.charCode) ? e.charCode : e.which;
    var ctrl = typeof e.modifiers == 'undefined' ? e.ctrlKey : e.modifiers & Event.CONTROL_MASK
    var shift = typeof e.modifiers == 'undefined' ? e.shiftKey : e.modifiers & Event.SHIFT_MASK;
    var alt = typeof e.modifiers == 'undefined' ? e.altKey : e.modifiers & Event.ALT_MASK;
    var cmd = typeof e.modifiers == 'undefined' ? e.metaKey : e.modifiers & 0x08;

    /*
    * Escの抑制
    */
    if (e.keyCode == 27) {
        DisableKey(e);
        return;
    }
    /*
    * Cmdの抑制
    * ->,<-,Delete,N,O,L,D,R,T,[,]
    */
    if (cmd) {
        if (e.keyCode == 37
			|| e.keyCode == 39
			|| e.keyCode == 8
			|| ch == 110 || ch == 111 || ch == 108 || ch == 100 || ch == 114 || ch == 116 || ch == 91 || ch == 93) {
            DisableKey(e);
            return;
        }
    }

    /*
    * Option_Home
    */
    if (alt) {
        if (e.keyCode == 36) {
            DisableKey(e);
            return;
        }
    }

    if (shift) {
        if (e.keyCode == 8) {
            DisableKey(e);
            return;
        }
    }

    /*
    * BackSpaceの抑制
    */
    if (e.keyCode == 8) {
        if ((e.target.tagName == "TEXTAREA") ||
				(e.target.tagName == "INPUT" &&
				(e.target.type == "text"
			|| e.target.type == "password"
			|| e.target.type == "file"))) {
            lastkey = "";
            return;
        }
        DisableKey(e);
        return;
    }
    /*
    *  F1～F12(112～123)の抑制
    */
    if (e.keyCode >= 112 && e.keyCode <= 123) {
        DisableKey(e);
        return;
    }

    lastkey = "";

}


function disableSafariKeys(e) {
    var ch3 = 0;
    ch3 = (e.keyCode) ? e.keyCode : (e.charCode) ? e.charCode : e.which;
    {
        if (ch3 == 16) { lastkey = 'SHIFT-'; }
        else if (ch3 == 17) { lastkey = 'CTRL-'; }
        else if (ch3 == 18) { lastkey = 'ALT-'; }
    }

    /*
    * Escの抑制
    */
    if (e.keyCode == 27) {
        DisableKey(e);
        return;
    }
    /*
    * Alt_Home, Alt_->, Alt_<-, Alt_Back Spaceの抑制
    */
    if (lastkey == 'ALT-') {
        if (e.keyCode == 36
			|| e.keyCode == 37
			|| e.keyCode == 39
			|| e.keyCode == 8) {
            DisableKey(e);
            return;
        }
    }
    /*
    * Ctrl+下記キーの抑制
    * Tab,B,D,E,F,H,I,L,N,O,R,W
    */
    if (lastkey == 'CTRL-') {
        if (e.keyCode == 9
			|| e.keyCode == 66
			|| e.keyCode == 68
			|| e.keyCode == 69
			|| e.keyCode == 70
			|| e.keyCode == 72
			|| e.keyCode == 73
			|| e.keyCode == 76
			|| e.keyCode == 78
			|| e.keyCode == 79
			|| e.keyCode == 82
			|| e.keyCode == 87) {
            DisableKey(e);
            return;
        }
    }
    /*
    * BackSpaceの抑制
    */
    if (e.keyCode == 8) {
        if ((e.target.tagName == "TEXTAREA") ||
				(e.target.tagName == "INPUT" &&
				(e.target.type == "text"
			|| e.target.type == "password"
			|| e.target.type == "file"))) {
            lastkey = "";
            return;
        }
        DisableKey(e);
        return;
    }
    /*
    *  F1～F12(112～123)の抑制
    */
    if (e.keyCode >= 112 && e.keyCode <= 123) {
        DisableKey(e);
        return;
    }

    if (ch3 != 16 && ch3 != 17 && ch3 != 18) {
        lastkey = "";
    }
}

function disableMacSafariKeys(e) {
    var ch3 = 0;
    ch3 = (e.keyCode) ? e.keyCode : (e.charCode) ? e.charCode : e.which;

    if (ch3 == 16) { lastkey = 'SHIFT-'; }
    else if (ch3 == 17) { lastkey = 'CTRL-'; }
    else if (ch3 == 18) { lastkey = 'ALT-'; }
    else if (ch3 == 91) { lastkey = 'COMMAND-'; }
   
    /*
    * Escの抑制
    */
    if (e.keyCode == 27) {
        DisableKey(e);
        return;
    }

    if (lastkey == 'SHIFT-') {
        if (e.keyCode == 8) {
            DisableKey(e);
            return;
        }
    }
    /*
    * Command + 下記キーの抑制
    * N,O,L,D,R,T,[,]
    */
    if (lastkey == 'COMMAND-') {
        if (e.keyCode == 78
			|| e.keyCode == 79
			|| e.keyCode == 76
			|| e.keyCode == 68
			|| e.keyCode == 82
			|| e.keyCode == 84
            || e.keyCode == 37
			|| e.keyCode == 39
			|| e.keyCode == 219
			|| e.keyCode == 221) {
            DisableKey(e);
            return;
        }
    }

    /*
    * Deleteキーを抑制
    */
    if (e.keyCode == 8) {
        if ((e.target.tagName == "TEXTAREA") ||
				(e.target.tagName == "INPUT" &&
				(e.target.type == "text"
			|| e.target.type == "password"
			|| e.target.type == "file"))) {
            lastkey = "";
            return;
        }
        DisableKey(e);
        return;
    }

    if (ch3 != 16 && ch3 != 17 && ch3 != 18 && ch3 != 91) {
        lastkey = "";
    }
}

function DisableKey(e) {
    lastkey = '';
    e.preventDefault();
    e.cancelBubble = true;
    e.returnValue = false;
    alert("この操作はできません。");
}

function disableContextIE() {
    event.cancelBubble = true;
    event.returnValue = false;
    return false;
}

function disableContext(e) {
    e.cancelBubble = true;
    e.returnValue = false;
    return false;
}

