﻿<%@ Page Title="" Language="VB" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
	入力ページ
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <script type="text/javascript" >
        function load_address() {
            var url = "../Postal/Postal/" + document.getElementById("zip1").value + document.getElementById("zip2").value;
            childWin = window.open(url, 'childWindowPostal', 'width=500,height=200,status=no,scrollbars=yes,directories=no,menubar=no,resizable=no,left=300,top=50');
        }

        function searchAddress() {
            document.getElementById("address1").value = childWin.document.getElementById("postal_address1").value;
            document.getElementById("address2").value = childWin.document.getElementById("postal_address2").value;
            document.getElementById("address3").value = childWin.document.getElementById("postal_address3").value;
            
            childWin.close();
        }

        function convHiraganaToKatakana(input) {
            var output = '';
            var c;
            var n;
            for (var i = 0; i < input.length; i++) {
                c = document.getElementById(input).value.charAt(i);
                n = c.charCodeAt(0);
                if ((n >= 0x3041) && (n <= 0x3096)) {
                    c = String.fromCharCode(n + 0x60);
                }
                output += c;
            }
            document.getElementById(input).value = output;
        }

    </script>

    <h2>入力ページ</h2>
    <p>
        <%= Html.ValidationSummary%>
    </p>
   
    <% Using Html.BeginForm()%>
        <%= ViewData("testdata")%>
        <table>
            <tr>
                <th>お名前</th>
                <td>
                    <table>
                        <tr>
                            <td>姓（漢字）</td>
                            <td><%= Html.TextBox("kanji_sei", ViewData("kanji_sei_value"), New With {.maxlength = "20"})%></td>
                            <td>名（漢字）</td>
                            <td><%= Html.TextBox("kanji_mei", ViewData("kanji_mei_value"), New With {.maxlength = "20"})%></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <th>カナ氏名</th>
                <td>
                    <table>
                        <tr>
                            <td>姓（カナ）</td>
                            <td><%= Html.TextBox("kana_sei", ViewData("kana_sei_value"), New With {.maxlength = "20", .onblur = "convHiraganaToKatakana('kana_sei')"})%></td>
                            <td>名（カナ）</td>
                            <td><%= Html.TextBox("kana_mei", ViewData("kana_mei_value"), New With {.maxlength = "20", .onblur = "convHiraganaToKatakana('kana_mei')"})%></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <th>生年月日</th>
                <td>
                    <%= Html.TextBox("birth_year", ViewData("birth_year_value"), New With {.maxlength = "4"})%>年
                    <%= Html.TextBox("birth_month", ViewData("birth_month_value"), New With {.maxlength = "2"})%>月
                    <%= Html.TextBox("birth_day", ViewData("birth_day_value"), New With {.maxlength = "2"})%>日
                </td>
            </tr>
            <tr>
                <th>性別</th>
                <td>
                     <% For Each item In Model%>
                        <%If item.selected Then%>
                            <%= Html.RadioButton("Gender", item.Value, True)%><%=Html.Label(item.Text)%> 
                        <%Else%>
                            <%= Html.RadioButton("Gender", item.Value, False)%><%=Html.Label(item.Text)%> 
                        <%End If%>
                    <%Next%>
                </td>
            </tr>
            <tr>
                <th>住所</th>
                <td>
                    <table>
                        <tr>
                            <td>郵便番号</td>
                            <td><%= Html.TextBox("zip1", ViewData("zip1_value"), New With {.maxlength = "3"})%> - <%= Html.TextBox("zip2", ViewData("zip2_value"), New With {.maxlength = "4"})%></td>
                            <td><input type="button" value="郵便番号から住所を選択する" onclick="load_address(); return false;"/></td>
                        </tr>
                    </table>
                    <table>
                        <tr>
                            <td>都道府県</td>
                            <td><%= Html.TextBox("address1", ViewData("address1_value"), New With {.maxlength = "30"})%></td>
                        </tr>
                        <tr>    
                            <td>市区郡</td>
                            <td><%= Html.TextBox("address2", ViewData("address2_value"), New With {.maxlength = "30"})%></td>
                        </tr>
                        <tr>
                            <td>町名・番地</td>
                            <td><%= Html.TextBox("address3", ViewData("address3_value"), New With {.maxlength = "40"})%></td>
                        </tr>
                        <tr>
                            <td>アパート・マンション名</td>
                            <td><%= Html.TextBox("address4", ViewData("address4_value"), New With {.maxlength = "40"})%></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <th>電話番号</th>
                <td>
                    <table>
                        <tr>
                            <td colspan="2">
                                ひとつ以上入力してください
                            </td>
                        </tr>
                        <tr>
                            <td>自宅電話番号</td>
                            <td><%= Html.TextBox("tel1", ViewData("tel1_value"), New With {.maxlength = "10"})%>-<%= Html.TextBox("tel2", ViewData("tel2_value"), New With {.maxlength = "10"})%>-<%= Html.TextBox("tel3", ViewData("tel3_value"), New With {.maxlength = "10"})%></td>
                        </tr>
                        <tr>
                            <td>携帯電話番号</td>
                            <td><%= Html.TextBox("m_tel1", ViewData("m_tel1_value"), New With {.maxlength = "3"})%>-<%= Html.TextBox("m_tel2", ViewData("m_tel2_value"), New With {.maxlength = "4"})%>-<%= Html.TextBox("m_tel3", ViewData("m_tel3_value"), New With {.maxlength = "4"})%></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <th>メールアドレス</th>
                <td>
                    <%= Html.TextBox("e_mail", ViewData("e_mail_value"), New With {.maxlength = "50"})%><br />
                    ※確認のため、もう一度ご入力ください<br />
                    <%= Html.TextBox("e_mail2", ViewData("e_mail2_value"), New With {.maxlength = "50"})%>            
                </td>
            </tr>
            <tr>
                <th>職業</th>
                <td><%= Html.DropDownList("occupation")%></td>
            </tr>
            <tr>
                <th>画像認証</th>
                <td>
                    <table>
                        <tr>
                            <td>不正アクセス防止のため、<br />右に表示されている画像認証<br />コードを入力ください</td>
                            <td><img src="<%= ViewData("watermarkUrl") %>" alt="画像認証"/><%= Html.TextBox("watermark", ViewData("watermark_value"), New With {.maxlength = "10"})%></td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <br />
        <input type="submit" name="button" value="次へ" />
    <% End Using %>
</asp:Content>
