﻿Imports Microsoft.Win32
Imports System.Text.RegularExpressions

' ユーティリティクラス
Public Class Util
    ' Web.configのAppSettingから情報を読み込む
    Public Shared Function GetAppSetting(ByVal Key As String) As String
        If Not HttpContext.Current.Session.Item("Label" & Key) Is Nothing Then
            Return HttpContext.Current.Session.Item("Label" & Key)
        End If

        ' ENV変数を読み込む
        Dim Env As String = Util.GetEnvironment

        ' AppSettingを読み込む
        Dim Value As String = ConfigurationManager.AppSettings(Key)
        Dim Value2 As String = ""

        'diffConfigを読み込む
        Dim hashConfig As Hashtable = TryCast(System.Configuration.ConfigurationManager.GetSection("diffConfig/" & Env), Hashtable)

        ' diffConfigに値がある場合優先する
        Value2 = hashConfig.Item(Key)

        If Value2 <> "" Then
            HttpContext.Current.Session.Item("Label" & Key) = Value2
            Return Value2
        Else
            HttpContext.Current.Session.Item("Label" & Key) = Value
            Return Value
        End If

    End Function

    ' サイトラベルを返す
    Public Shared Function GetSiteLabel() As String
        If Not HttpContext.Current.Session.Item("SiteLabel") Is Nothing Then
            Return HttpContext.Current.Session.Item("SiteLabel")
        End If

        ' ENV変数を取得する
        Dim Value As String = GetEnvironment()

        ' PRODのとき値をクリアする
        If Value = "PROD" Then
            Value = ""
        End If

        HttpContext.Current.Session.Item("SiteLabel") = Value
        Return Value
    End Function

    ' ENV変数を取得する
    Public Shared Function GetEnvironment() As String
        If Not HttpContext.Current.Session.Item("Environment") Is Nothing Then
            Return HttpContext.Current.Session.Item("Environment")
        End If

        Dim Value As String = getRegValue("SOFTWARE\yoyoyoyo.jp\ENV", "Label")

        ' 値がないとき、PRODとして扱う
        If Value = "" Then
            Value = "PROD"
        End If

        HttpContext.Current.Session.Item("Environment") = Value
        Return Value
    End Function

    ' レジストリキーの取得
    Public Shared Function getRegValue(ByVal RegKeyPath As String, ByVal Value As String) As String
        Dim RegKey As RegistryKey = Registry.LocalMachine.OpenSubKey(RegKeyPath, False)
        If RegKey Is Nothing Then
            Return ""
        Else
            Return RegKey.GetValue(Value, "").ToString
        End If
    End Function

    ' XMLデータからリストアイテムに値をセットする
    Public Shared Sub AddListItem(ByRef ctrl As List(Of SelectListItem), ByVal KeyNo As Integer)
        Dim xmldoc As XElement = GetDataXML()
        Dim query As IEnumerable(Of XElement) = From x In xmldoc.Descendants("WebFormData") Where x.Attribute("Value1").Value = KeyNo Order By Integer.Parse(x.Attribute("SortNo").Value) Ascending

        For Each i As XElement In query
            Dim Value2 As String = i.Attribute("Value2")
            Dim JPNAME As String = i.Attribute("JPNAME")

            ctrl.Add(New SelectListItem() With {.Text = JPNAME, .Value = Value2})
        Next
    End Sub

    ' XMLデータのコード番号からJPNAMEを取得する
    Public Shared Function GetDataName(ByVal keyNo As String, ByVal Code As String) As String
        Dim JPNAME As String = ""
        Dim xmldoc As XElement = GetDataXML()

        Dim query As IEnumerable(Of XElement) = From x In xmldoc.Descendants("WebFormData") Where x.Attribute("Value1").Value = keyNo AndAlso x.Attribute("Value2").Value = Code

        For Each i As XElement In query
            JPNAME = i.Attribute("JPNAME")
        Next

        Return JPNAME
    End Function

    ' データ用XMLファイルを読み込む
    Public Shared Function GetDataXML() As XElement
        If Not HttpContext.Current.Session.Item("SessionDataXmlPath") Is Nothing Then
            Return HttpContext.Current.Session.Item("SessionDataXmlPath")
        End If

        Dim Path As String = Util.GetAppSetting("DataXmlPath")
        Dim FullPath As String = HttpContext.Current.Server.MapPath(Path)
        Dim xmldoc As XElement = XElement.Load(FullPath)

        HttpContext.Current.Session.Item("SessionDataXmlPath") = xmldoc
        Return xmldoc
    End Function

    ' DBコネクションストリングを取得する
    Public Shared Function GetConnectionString() As String
        If Not HttpContext.Current.Session.Item("SessionDBConnectionString") Is Nothing Then
            Return HttpContext.Current.Session.Item("SessionDBConnectionString")
        End If

        Dim RegKey As String = Util.GetAppSetting("DBConnectionRegKey")

        Dim DBServer As String = getRegValue(RegKey, "DBServer")
        Dim DBPort As String = getRegValue(RegKey, "DBPort")
        Dim DBName As String = getRegValue(RegKey, "DBName")
        Dim DBUser As String = getRegValue(RegKey, "DBUser")
        Dim DBEncryptedSeedKey As String = getRegValue(RegKey, "DBEncryptedSeedKey")
        Dim DBEncryptedPassword As String = getRegValue(RegKey, "DBEncryptedPassword")
        Dim DBDecryptedPassword As String = Crypt.DecryptTripleDES(DBEncryptedSeedKey, DBEncryptedPassword)

        HttpContext.Current.Session.Item("SessionDBConnectionString") = "Data Source=" & DBServer _
            & CStr(IIf(DBPort = "", "", "," & DBPort)) & ";" _
            & "Initial Catalog=" & DBName & ";" _
            & "User ID=" & DBUser & ";" _
            & "Password=" & DBDecryptedPassword & ";"

        Return "Data Source=" & DBServer _
             & CStr(IIf(DBPort = "", "", "," & DBPort)) & ";" _
             & "Initial Catalog=" & DBName & ";" _
             & "User ID=" & DBUser & ";" _
             & "Password=" & DBDecryptedPassword & ";"
    End Function

    ' 数値のみかどうか判定する
    Public Shared Function IsNumeric(ByVal value As String) As Boolean
        Dim reg As Regex = New Regex("^[0-9]*$")

        Return reg.IsMatch(value)
    End Function

    ' メールアドレスかどうか判定する
    Public Shared Function IsMail(ByVal value As String) As Boolean
        Dim reg As Regex = New Regex("^[a-zA-Z_0-9]+([-+.][a-zA-Z_0-9]+)*@[a-zA-Z_0-9]+([-.][a-zA-Z_0-9]+)*\.[a-zA-Z_0-9]+([-.][a-zA-Z_0-9]+)*$")

        Return reg.IsMatch(value)
    End Function

    ' 全角カタカナかどうか判定する
    Public Shared Function IsKatakana(ByVal value As String) As Boolean
        Dim reg As Regex = New Regex("^[ァ-ヶ|ー]+$")

        Return reg.IsMatch(value)
    End Function

    ' 機種依存文字が含まれているかどうか判定する
    Public Shared Function IncludeSpecialCharacter(ByVal value As String) As Boolean
        Dim reg As Regex = New Regex("[①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤ≡∑∫∮√⊥∠∟⊿∵∩∪№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹㍾㍽㍼㍻㍉㎜㎝㎞㎎㎏㏄㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ]+")

        Return reg.IsMatch(value)
    End Function

    ' 半角文字が含まれているかどうか判定する
    Public Shared Function IncludeHarfCharacter(ByVal value As String) As Boolean
        Dim reg As Regex = New Regex("[ -~｡-ﾟ]+")

        Return reg.IsMatch(value)
    End Function

    ' 全角アルファベットが含まれているかどうか判定する
    Public Shared Function IncludeZenAlphabet(ByVal value As String) As Boolean
        Dim reg As Regex = New Regex("[ａ-ｚＡ-Ｚ]+")

        Return reg.IsMatch(value)
    End Function

    ' 全角数字が含まれているかどうか判定する
    Public Shared Function IncludeZenNumeric(ByVal value As String) As Boolean
        Dim reg As Regex = New Regex("[０-９]+")

        Return reg.IsMatch(value)
    End Function

    ' HTMLエンコード
    Public Shared Function GetHtmlEncode(ByVal value As String) As String
        Return HttpUtility.HtmlEncode(value)
    End Function

    ' HTMLデコード
    Public Shared Function GetHtmlDecode(ByVal value As String) As String
        Return HttpUtility.HtmlDecode(value)
    End Function
End Class
