﻿Imports System.Data.Linq
Imports WebFormManager.Models
Imports System.Transactions

<HandleError()> _
Public Class AccountController
    Inherits System.Web.Mvc.Controller

    Public Function LogOn() As ActionResult
        Return View()
    End Function

    <HttpPost()> _
    Public Function LogOn(ByVal collection As FormCollection) As ActionResult
        Dim encryptPassword As String = Crypt.EncryptSHA256(collection.Item("password"))

        collection.Item("operator_id") = collection.Item("operator_id").Trim

        ' バリデーション
        If collection.Item("operator_id") = "" Then
            ModelState.AddModelError("", "オペレータIDを入力してください")
        End If

        If collection.Item("password") = "" Then
            ModelState.AddModelError("", "パスワードを入力してください")
        End If

        ' バリデーションエラーが発生したとき
        If Not ModelState.IsValid Then
            Return View()
        End If
        Dim connStr As String = Util.GetConnectionString
        Dim dc As WebFormDBDataContext = New WebFormDBDataContext(connStr)

        Dim Auth As Boolean = False
        Dim Lock As Boolean = False
        Dim Disabled As Boolean = False
        Try
            ' ロックされているか判定する
            dc.checkUserLock(Lock, collection.Item("operator_id"))

            ' ロックされているときメッセージを表示する
            If Lock = True Then
                ModelState.AddModelError("", "オペレータ(" & collection.Item("operator_id") & ")はロックされています。管理者までご連絡ください")

                If Not ModelState.IsValid Then
                    Return View()
                End If
            End If

            ' 無効化されているか判定する
            dc.checkUserDisabled(Disabled, collection.Item("operator_id"))

            ' 無効化されているとき
            If Disabled = True Then
                ModelState.AddModelError("", "オペレータ(" & collection.Item("operator_id") & ")は無効化されています。管理者までご連絡ください")

                If Not ModelState.IsValid Then
                    Return View()
                End If
            End If

            ' パスワードがあっているか判定する
            dc.checkPassword(Auth, collection.Item("operator_id"), encryptPassword)

            If Auth = True Then ' パスワードが正しい
                ' データベースから情報を読み込む
                Dim user = (From u In dc.GetTable(Of MstUser)() Where u.OPERATOR_ID = collection.Item("operator_id")).First
                Dim role = From rmap In dc.GetTable(Of MapRole)()
                           Join rmst In dc.GetTable(Of MstRole)() On rmap.ROLE_ID Equals rmst.ROLE_ID
                           Where rmap.OPERATOR_ID = collection.Item("operator_id")
                Dim rolemst = From rmst In dc.GetTable(Of MstRole)()

                ' アカウント情報を初期化する
                Dim acc As AccountInfo = New AccountInfo
                acc.IsLogin = True
                acc.OPERATOR_ID = user.OPERATOR_ID
                acc.OPERATOR_NAME = user.OPERATOR_NAME
                acc.LAST_LOGIN_DATE = user.LAST_LOGIN_DATE
                acc.LAST_LOGIN_DATE2 = user.LAST_LOGIN_DATE2
                acc.LAST_PASSWORD_CHANGE = DateTime.Parse(user.LAST_PASSWORD_CHANGE)

                ' ロールの処理
                For Each item In rolemst
                    acc.ROLE.Add(item.ROLE_NAME, False)
                Next

                For Each item In role
                    acc.ROLE.Item(item.rmst.ROLE_NAME) = True
                Next

                ' 初期化されたパスワードのとき
                If user.INITIAL_PASSWORD = True Then
                    ModelState.AddModelError("", "初期化されたパスワードです。パスワードを更新してください")

                    If Not ModelState.IsValid Then
                        Return View()
                    End If
                End If

                ' パスワードの有効期限が過ぎたとき
                If acc.LAST_PASSWORD_CHANGE.AddDays(CInt(Util.GetAppSetting("PasswordExpirationDay"))) < DateTime.Now Then
                    ModelState.AddModelError("", "パスワードの有効期限が過ぎています。パスワードを更新してください")

                    If Not ModelState.IsValid Then
                        Return View()
                    End If
                End If

                Session.Clear()

                Session("AccountInfo") = acc

                ' データベースに書き込む
                ' 1)最終ログイン日時
                ' 2)ログイン失敗カウントの初期化
                ' 3)ログインログ
                Using ts = New TransactionScope
                    dc.updateLastLoginDate(collection.Item("operator_id"))
                    dc.resetFailedCount(collection.Item("operator_id"))
                    dc.insertLoginLog(collection.Item("operator_id"), True, System.Web.HttpContext.Current.Request.UserHostAddress, Session.SessionID)
                    dc.SubmitChanges()
                    ts.Complete()

                End Using
                Return RedirectToAction("Index", "Home")
            Else ' パスワードが間違っている
                Using ts = New TransactionScope

                    ' ユーザ情報の取得
                    Dim user = (From u In dc.GetTable(Of MstUser)() Where u.OPERATOR_ID = collection.Item("operator_id")).FirstOrDefault

                    ' ユーザが存在するとき
                    If Not user Is Nothing Then
                        ' ログイン失敗カウントをインクリメント
                        dc.incrementFailedCount(collection.Item("operator_id"))

                        ' ログイン失敗カウントが一定数以上だったらユーザをロックする
                        If user.FAILED_COUNT >= (CInt(Util.GetAppSetting("PasswordFailedCount")) - 1) Then
                            dc.updateUserLock(collection.Item("operator_id"), True)
                        End If


                    End If
                    ' ログインログを書き込む
                    dc.insertLoginLog(collection.Item("operator_id"), False, System.Web.HttpContext.Current.Request.UserHostAddress, Session.SessionID)


                    dc.SubmitChanges()
                    ts.Complete()
                End Using

                ' ログインに失敗したことを表示
                ModelState.AddModelError("", "ログインに失敗しました")

                Return View()
            End If
        Catch ex As Exception
            Return RedirectToAction("Maintenance", "Home")
        End Try
    End Function

    Public Function LogOff() As ActionResult
        Session.Clear()
        Return RedirectToAction("Index", "Home")
    End Function

    Public Function PasswordChange() As ActionResult
        Dim data As PasswordChangeData = TryCast(Session("PasswordChangeData"), PasswordChangeData)

        If Not data Is Nothing Then
            ViewData("operator_id_value") = data.OPERATOR_ID
        End If

        Return View()
    End Function

    <HttpPost()> _
    Public Function PasswordChange(ByVal collection As FormCollection) As ActionResult
        Dim connStr As String = Util.GetConnectionString
        Dim dc As WebFormDBDataContext = New WebFormDBDataContext(connStr)

        If collection("button") = "確認" Then ' 確認ボタンを押したとき
            ' Trim
            collection("operator_id") = collection("operator_id").Trim
            ' 再表示用に設定
            ViewData("operator_id_value") = collection("operator_id")

            ' バリデーション
            ' オペレータID
            If collection("operator_id") = "" Then
                ModelState.AddModelError("", "オペレータIDは必須項目です")
            Else
                If collection("old_password") = "" Then
                    ModelState.AddModelError("", "旧パスワードは必須項目です")
                Else
                    Dim encryptPassword As String = Crypt.EncryptSHA256(collection.Item("old_password"))
                    Dim pw = From t In dc.GetTable(Of MstUser)() Where t.OPERATOR_ID = collection("operator_id") AndAlso t.ENCRYPTED_PASSWORD = encryptPassword

                    If pw.Count = 0 Then
                        ModelState.AddModelError("", "オペレータIDまたは旧パスワードが間違っています")
                    End If
                End If

            End If
            ' パスワード
            If collection("new_password") = "" Then
                ModelState.AddModelError("", "新パスワードは必須項目です")
            ElseIf Not Util.ValidatePassword(collection("new_password")) Then
                ModelState.AddModelError("", "新パスワードは半角英数字6文字-20文字で入力してください。また、英大文字、英小文字、数字の3種類の文字を含む必要があります。")
            End If


            If collection("new_password") <> collection("new_password2") Then
                ModelState.AddModelError("", "新パスワードと新パスワード(確認)が異なっています")
            End If

            If Not ModelState.IsValid Then
                Return View()
            End If

            ' パスワード情報をオブジェクトに格納
            Dim data As PasswordChangeData = New PasswordChangeData
            data.OPERATOR_ID = collection("operator_id")
            data.PASSWORD = collection("new_password")

            ' パスワード情報をセッションに格納
            Session("PasswordChangeData") = data

            Return RedirectToAction("PasswordChangeConfirm", "Account")
        Else    ' 戻るボタンを押したとき
            Session("PasswordChangeData") = Nothing
            Return RedirectToAction("LogOn", "Account")
        End If


    End Function

    Public Function PasswordChangeConfirm() As ActionResult
        Dim data As PasswordChangeData = TryCast(Session("PasswordChangeData"), PasswordChangeData)

        ' パスワード変更情報を表示
        ViewData("operator_id") = data.OPERATOR_ID
        ViewData("password") = "**********"

        Return View()
    End Function

    <HttpPost()> _
    Public Function PasswordChangeConfirm(ByVal collection As FormCollection) As ActionResult
        Dim data As PasswordChangeData = TryCast(Session("PasswordChangeData"), PasswordChangeData)

        If collection("button") = "保存" Then ' 保存ボタンを押したとき
            Dim connStr As String = Util.GetConnectionString
            Dim dc As WebFormDBDataContext = New WebFormDBDataContext(connStr)

            ' SHA256で暗号化
            Dim encryptPassword As String = Crypt.EncryptSHA256(data.PASSWORD)

            ' データベースを更新
            Try
                dc.updatePassword(data.OPERATOR_ID, False, encryptPassword)
                dc.SubmitChanges()
            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try

            ' メッセージボックスを表示
            Session("MessageBoxTitle") = "パスワード変更完了"
            Session("MessageBoxMessage") = "パスワード変更が完了しました"

            Session("PasswordChangeData") = Nothing

            Return RedirectToAction("MessageBox", "Account")
        Else ' 戻るボタンを押したとき
            Return RedirectToAction("PasswordChange", "Account")
        End If

    End Function

    Function MessageBox() As ActionResult
        ViewData("MessagaBoxTitle") = Session("MessageBoxTitle")
        ViewData("MessageBoxMessage") = Session("MessageBoxMessage")

        Return View()
    End Function

    <HttpPost()>
    Function MessageBox(ByVal collection As FormCollection) As ActionResult
        Session("MessageBoxTitle") = Nothing
        Session("MessageBoxMessage") = Nothing

        Return RedirectToAction("LogOn", "Account")
    End Function
End Class
