﻿Imports System.Data.Linq
Imports WebFormManager.Models
Imports System.Transactions


<HandleError()> _
Public Class HomeController
    Inherits System.Web.Mvc.Controller

    Function Index() As ActionResult
        Return View()
    End Function

    Function List() As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing OrElse Not (acc.ROLE("Read") OrElse acc.ROLE("Write")) Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Return View()
    End Function

    <HttpPost()> _
    Function List(ByVal collection As FormCollection) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing OrElse Not (acc.ROLE("Read") OrElse acc.ROLE("Write")) Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        ' Trim
        collection.Item("seq_id") = collection.Item("seq_id").Trim
        collection.Item("kanji_sei") = collection.Item("kanji_sei").Trim
        collection.Item("kanji_mei") = collection.Item("kanji_mei").Trim
        collection.Item("kana_sei") = collection.Item("kana_sei").Trim
        collection.Item("kana_mei") = collection.Item("kana_mei").Trim
        collection.Item("zip") = collection.Item("zip").Trim
        collection.Item("email") = collection.Item("email").Trim
        collection.Item("from_date") = collection.Item("from_date").Trim
        collection.Item("to_date") = collection.Item("to_date").Trim
        ' 再設定
        ViewData("seq_id_value") = collection.Item("seq_id")
        ViewData("kanji_sei_value") = collection.Item("kanji_sei")
        ViewData("kanji_mei_value") = collection.Item("kanji_mei")
        ViewData("kana_sei_value") = collection.Item("kana_sei")
        ViewData("kana_mei_value") = collection.Item("kana_mei")
        ViewData("zip_value") = collection.Item("zip")
        ViewData("email_value") = collection.Item("email")
        ViewData("from_date_value") = collection.Item("from_date")
        ViewData("to_date_value") = collection.Item("to_date")
        ' バリデーション
        If collection.Item("seq_id") = "" AndAlso
           collection.Item("kanji_sei") = "" AndAlso
           collection.Item("kanji_mei") = "" AndAlso
           collection.Item("kana_sei") = "" AndAlso
           collection.Item("kana_mei") = "" AndAlso
           collection.Item("zip") = "" AndAlso
           collection.Item("email") = "" AndAlso
           collection.Item("from_date") = "" AndAlso
           collection.Item("to_date") = "" Then
            ModelState.AddModelError("", "検索項目を入力してください")
        End If

        If (collection.Item("from_date") <> "" AndAlso collection.Item("to_date") = "") OrElse
           (collection.Item("from_date") = "" AndAlso collection.Item("to_date") <> "") Then
            ModelState.AddModelError("", "開始日付と終了日付は両方とも入力してください")
        End If

        If Not Util.IsNumeric(collection.Item("seq_id")) Then
            ModelState.AddModelError("", "申込番号は数字で入力してください")
        End If

        If Not Util.IsNumeric(collection.Item("zip")) Then
            ModelState.AddModelError("", "郵便番号は数字７桁で入力してください")
        End If

        If collection.Item("from_date") <> "" AndAlso Not IsDate(collection.Item("from_date")) Then
            ModelState.AddModelError("", "開始日付は有効な日付(YYYY/MM/DD)で入力してください")
        End If

        If collection.Item("to_date") <> "" AndAlso Not IsDate(collection.Item("to_date")) Then
            ModelState.AddModelError("", "終了日付は有効な日付(YYYY/MM/DD)で入力してください")
        End If

        If Not ModelState.IsValid Then
            Return List()
        End If

        ' データベースからの読み込み
        Dim connStr As String = Util.GetConnectionString
        Dim dc As WebFormDBDataContext = New WebFormDBDataContext(connStr)
        Dim model As DBModelRequestData = New DBModelRequestData

        Dim seq_id As Integer = 0
        If collection.Item("seq_id") <> "" Then
            seq_id = CInt(collection.Item("seq_id"))
        End If
        Dim from_date As DateTime = DateTime.MinValue
        If collection.Item("from_date") <> "" Then
            from_date = DateTime.Parse(collection.Item("from_date"))
        End If
        Dim to_date As DateTime = DateTime.MaxValue
        If collection.Item("to_date") <> "" Then
            to_date = DateTime.Parse(collection.Item("to_date")).AddDays(1)
        End If

        Dim page As Integer = If(Session("list_page"), 0)
        If collection("button") = "前頁" Then
            page = page - 1
        ElseIf collection("button") = "次頁" Then
            page = page + 1
        Else
            page = page
        End If
        Session("list_page") = page
        Dim MaxItem As Integer = CInt(Util.GetAppSetting("PageSizeRequestList"))
        Dim curPage As Integer = page
        Dim max As Integer = 0
        Try
            max = (From r In dc.GetTable(Of RequestData)() Select r
                           Where (collection.Item("seq_id") = "" OrElse r.SEQ_ID = seq_id) AndAlso
                             (collection.Item("kanji_sei") = "" OrElse r.SEI_KANJI = collection.Item("kanji_sei")) AndAlso
                              (collection.Item("kanji_mei") = "" OrElse r.MEI_KANJI = collection.Item("kanji_mei")) AndAlso
                            (collection.Item("kana_sei") = "" OrElse r.SEI_KANA = collection.Item("kana_sei")) AndAlso
                            (collection.Item("kana_mei") = "" OrElse r.MEI_KANA = collection.Item("kana_mei")) AndAlso
                            (collection.Item("zip") = "" OrElse (r.ZIP1 & r.ZIP2) = collection.Item("zip")) AndAlso
                            (collection.Item("email") = "" OrElse r.E_MAIL = collection.Item("email")) AndAlso
                            (collection.Item("from_date") = "" OrElse r.REQUEST_DATE >= from_date) AndAlso
                             (collection.Item("to_date") = "" OrElse r.REQUEST_DATE <= to_date)).Count

            model.RequestData = (From r In dc.GetTable(Of RequestData)() Select r
                                Where (collection.Item("seq_id") = "" OrElse r.SEQ_ID = seq_id) AndAlso
                                  (collection.Item("kanji_sei") = "" OrElse r.SEI_KANJI = collection.Item("kanji_sei")) AndAlso
                                   (collection.Item("kanji_mei") = "" OrElse r.MEI_KANJI = collection.Item("kanji_mei")) AndAlso
                                 (collection.Item("kana_sei") = "" OrElse r.SEI_KANA = collection.Item("kana_sei")) AndAlso
                                 (collection.Item("kana_mei") = "" OrElse r.MEI_KANA = collection.Item("kana_mei")) AndAlso
                                 (collection.Item("zip") = "" OrElse (r.ZIP1 & r.ZIP2) = collection.Item("zip")) AndAlso
                                 (collection.Item("email") = "" OrElse r.E_MAIL = collection.Item("email")) AndAlso
                                 (collection.Item("from_date") = "" OrElse r.REQUEST_DATE >= from_date) AndAlso
                                  (collection.Item("to_date") = "" OrElse r.REQUEST_DATE <= to_date)).Skip(curPage * MaxItem).Take(MaxItem)
        Catch ex As Exception
            Return RedirectToAction("Maintenance", "Home")
        End Try
       

        model.CurrentPage = curPage
        ' 前頁があるかどうか
        If curPage = 0 Then
            model.HasPrevPage = False
        Else
            model.HasPrevPage = True
        End If
        ' 次頁があるかどうか
        If curPage * MaxItem + MaxItem < max Then
            model.HasNextPage = True
        Else
            model.HasNextPage = False
        End If

        Return View(model)
    End Function

    Function Download() As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing OrElse Not acc.ROLE("CSV Download") Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        ' 開始日付（年）の設定
        Dim itemsFromYear As List(Of SelectListItem) = New List(Of SelectListItem)()

        itemsFromYear.Add(New SelectListItem() With {.Text = "----", .Value = "----"})
        For i As Integer = 1990 To DateTime.Now.Year
                itemsFromYear.Add(New SelectListItem() With {.Text = i.ToString, .Value = i.ToString})
        Next

        Dim FromYear As SelectList

        If Not Session("DownloadFromYear") Is Nothing Then
            FromYear = New SelectList(itemsFromYear, "Value", "Text", Session("DownloadFromYear"))
        Else
            FromYear = New SelectList(itemsFromYear, "Value", "Text")
        End If


        ' 終了日付（年）の設定
        Dim itemsToYear As List(Of SelectListItem) = New List(Of SelectListItem)()

        itemsToYear.Add(New SelectListItem() With {.Text = "----", .Value = "----"})
        For i As Integer = 1990 To DateTime.Now.Year
                itemsToYear.Add(New SelectListItem() With {.Text = i.ToString, .Value = i.ToString})
        Next

        Dim ToYear As SelectList

        If Not Session("DownloadToYear") Is Nothing Then
            ToYear = New SelectList(itemsToYear, "Value", "Text", Session("DownloadToYear"))
        Else
            ToYear = New SelectList(itemsToYear, "Value", "Text")
        End If

        ' 開始日付（月）の設定
        Dim itemsFromMonth As List(Of SelectListItem) = New List(Of SelectListItem)()

        itemsFromMonth.Add(New SelectListItem() With {.Text = "--", .Value = "--"})
        For i As Integer = 1 To 12
                itemsFromMonth.Add(New SelectListItem() With {.Text = String.Format("{0:00}", i), .Value = String.Format("{0:00}", i)})
        Next

        Dim FromMonth As SelectList

        If Not Session("DownloadFromMonth") Is Nothing Then
            FromMonth = New SelectList(itemsFromMonth, "Value", "Text", Session("DownloadFromMonth"))
        Else
            FromMonth = New SelectList(itemsFromMonth, "Value", "Text")
        End If

        ' 終了日付（月）の設定
        Dim itemsToMonth As List(Of SelectListItem) = New List(Of SelectListItem)()

        itemsToMonth.Add(New SelectListItem() With {.Text = "--", .Value = "--"})
        For i As Integer = 1 To 12
            itemsToMonth.Add(New SelectListItem() With {.Text = String.Format("{0:00}", i), .Value = String.Format("{0:00}", i)})
            
        Next

        Dim ToMonth As SelectList

        If Not Session("DownloadToMonth") Is Nothing Then
            ToMonth = New SelectList(itemsToMonth, "Value", "Text", Session("DownloadToMonth"))
        Else
            ToMonth = New SelectList(itemsToMonth, "Value", "Text")
        End If

        ' 開始日付（日）の設定
        Dim itemsFromDay As List(Of SelectListItem) = New List(Of SelectListItem)()

        itemsFromDay.Add(New SelectListItem() With {.Text = "--", .Value = "--"})
        For i As Integer = 1 To 31
            itemsFromDay.Add(New SelectListItem() With {.Text = String.Format("{0:00}", i), .Value = String.Format("{0:00}", i)})
        Next

        Dim FromDay As SelectList

        If Not Session("DownloadFromDay") Is Nothing Then
            FromDay = New SelectList(itemsFromDay, "Value", "Text", Session("DownloadFromDay"))
        Else
            FromDay = New SelectList(itemsFromDay, "Value", "Text")
        End If

        ' 終了日付（日）の設定
        Dim itemsToDay As List(Of SelectListItem) = New List(Of SelectListItem)()

        itemsToDay.Add(New SelectListItem() With {.Text = "--", .Value = "--"})
        For i As Integer = 1 To 31
            itemsToDay.Add(New SelectListItem() With {.Text = String.Format("{0:00}", i), .Value = String.Format("{0:00}", i)})
        Next

        Dim ToDay As SelectList

        If Not Session("DownloadToDay") Is Nothing Then
            ToDay = New SelectList(itemsToDay, "Value", "Text", Session("DownloadToDay"))
        Else
            ToDay = New SelectList(itemsToDay, "Value", "Text")
        End If

 
        ' プルダウンメニューにセット
        ViewData("FromYear") = FromYear
        ViewData("FromMonth") = FromMonth
        ViewData("FromDay") = FromDay
        ViewData("ToYear") = ToYear
        ViewData("ToMonth") = ToMonth
        ViewData("ToDay") = ToDay
        Return View()
    End Function

    <HttpPost()>
    Function Download(ByVal collection As FormCollection) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing OrElse Not acc.ROLE("CSV Download") Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim fromYear As String = collection.Item("FromYear")
        Dim fromMonth As String = collection.Item("FromMonth")
        Dim fromDay As String = collection.Item("FromDay")
        Dim toYear As String = collection.Item("ToYear")
        Dim toMonth As String = collection.Item("ToMonth")
        Dim toDay As String = collection.Item("ToDay")

        Session("DownloadFromYear") = fromYear
        Session("DownloadFromMonth") = fromMonth
        Session("DownloadFromDay") = fromDay
        Session("DownloadToYear") = toYear
        Session("DownloadToMonth") = toMonth
        Session("DownloadToDay") = toDay

        ' バリデーション
        If fromYear = "----" OrElse fromMonth = "--" OrElse fromDay = "--" OrElse
            toYear = "----" OrElse toMonth = "--" OrElse toDay = "" Then
            ModelState.AddModelError("", "日付を選択してください")
        End If

        If Not IsDate(fromYear & "/" & fromMonth & "/" & fromDay) Then
            ModelState.AddModelError("", "開始日付が有効ではありません")
        End If

        If Not IsDate(toYear & "/" & toMonth & "/" & toDay) Then
            ModelState.AddModelError("", "終了日付が有効ではありません")
        End If

        If Not ModelState.IsValid Then
            Return Download()
        End If

        ' データベースから読み込む
        Dim connStr As String = Util.GetConnectionString
        Dim dc As WebFormDBDataContext = New WebFormDBDataContext(connStr)
        Dim model As DBModelRequestData = New DBModelRequestData

        Dim from_date As DateTime = DateTime.Parse(fromYear & "/" & fromMonth & "/" & fromDay)
        Dim to_date As DateTime = DateTime.Parse(toYear & "/" & toMonth & "/" & toDay).AddDays(1)

        Try
            model.RequestData = From r In dc.GetTable(Of RequestData)() Select r
                      Where r.REQUEST_DATE >= from_date AndAlso r.REQUEST_DATE <= to_date
        Catch ex As Exception
            Return RedirectToAction("Maintenance", "Home")
        End Try
  

        Dim count As Integer = model.RequestData.Count

        'コンテントタイプ 
        Response.ContentType = "application/octet-stream"

        '添付ファイル 
        Response.AddHeader("Content-Disposition", "attachment; filename=" + HttpUtility.UrlEncode("WebForm_" & fromYear & fromMonth & fromDay & "_" & toYear & toMonth & toDay & ".csv"))


        Dim csvstr As StringBuilder = New StringBuilder
        If model.RequestData.Count = 0 Then
            csvstr.Append("No Data")
        Else
            For Each item In model.RequestData
                csvstr.Append(item.SEQ_ID & ",")
                csvstr.Append(item.SEI_KANJI & ",")
                csvstr.Append(item.MEI_KANJI & ",")
                csvstr.Append(item.SEI_KANA & ",")
                csvstr.Append(item.MEI_KANA & ",")
                csvstr.Append(String.Format("{0:0000}/{1:00}/{2:00}", item.BIRTH_DATE.Substring(0, 4), item.BIRTH_DATE.Substring(4, 2), item.BIRTH_DATE.Substring(6, 2)) & ",")
                csvstr.Append(item.GENDER_TEXT & ",")
                csvstr.Append(item.ZIP1 & "-" & item.ZIP2 & ",")
                csvstr.Append(item.ADDRESS1 & ",")
                csvstr.Append(item.ADDRESS2 & ",")
                csvstr.Append(item.ADDRESS3 & ",")
                csvstr.Append(item.ADDRESS4 & ",")
                csvstr.Append(item.TEL1 & "-" & item.TEL2 & "-" & item.TEL3 & ",")
                csvstr.Append(item.M_TEL1 & "-" & item.M_TEL2 & "-" & item.M_TEL3 & ",")
                csvstr.Append(item.E_MAIL & ",")
                csvstr.Append(item.OCCUPATION_TEXT & ",")
                csvstr.Append(item.REQUEST_DATE.ToString("yyyy/MM/dd HH:mm:ss") & vbCrLf)
            Next
        End If

 
        'CSV出力 
        Response.Write(csvstr.ToString)

        'レスポンス出力終了 
        Response.End()

        'ログの出力
        Try
            dc.insertDownloadLog(acc.OPERATOR_ID, HttpUtility.UrlEncode("WebForm_" & fromYear & fromMonth & fromDay & "_" & toYear & toMonth & toDay & ".csv"), count, System.Web.HttpContext.Current.Request.UserHostAddress, Session.SessionID)
        Catch ex As Exception
            Return RedirectToAction("Maintenance", "Home")
        End Try

        Return View()
    End Function

    Function Detail(ByVal id As String) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing OrElse Not (acc.ROLE("Read") OrElse acc.ROLE("Write")) Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim connStr As String = Util.GetConnectionString
        Dim dc As WebFormDBDataContext = New WebFormDBDataContext(connStr)
        Dim model As RequestData = New RequestData

        ' 申し込みデータの取得
        Try
            model = (From r In dc.GetTable(Of RequestData)() Select r
                                       Where r.SEQ_ID = id).First
        Catch ex As Exception
            Return RedirectToAction("Maintenance", "Home")
        End Try

        ' 申し込みデータの表示
        ViewData("seq_id") = model.SEQ_ID
        ViewData("status") = model.STATUS_TEXT
        ViewData("kanji_name") = model.SEI_KANJI & " " & model.MEI_KANJI
        ViewData("kana_name") = model.SEI_KANA & " " & model.MEI_KANA
        ViewData("birthdate") = String.Format("{0:0000}/{1:00}/{2:00}", model.BIRTH_DATE.Substring(0, 4), model.BIRTH_DATE.Substring(4, 2), model.BIRTH_DATE.Substring(6, 2))
        ViewData("gender") = model.GENDER_TEXT
        ViewData("zip") = model.ZIP1 & "-" & model.ZIP2
        ViewData("address") = model.ADDRESS1 & model.ADDRESS2 & model.ADDRESS3 & model.ADDRESS4
        ViewData("tel") = model.TEL1 & "-" & model.TEL2 & "-" & model.TEL3
        ViewData("m_tel") = model.M_TEL1 & "-" & model.M_TEL2 & "-" & model.M_TEL3
        ViewData("email") = model.E_MAIL
        ViewData("occupation") = model.OCCUPATION_TEXT
        ViewData("request_date") = model.REQUEST_DATE.ToString("yyyy/MM/dd HH:mm:ss")
        ViewData("ip_address") = model.IP_ADDRESS
        ViewData("session_id") = model.SESSION_ID

        ' コメントの取得
        Dim comment = From r In dc.GetTable(Of StatusHistory)() Where r.SEQ_ID = model.SEQ_ID
                      Select New CommentData With {
                          .SEQ_ID = r.SEQ_ID,
                          .OLD_STATUS = r.OLD_STATUS,
                          .OLD_STATUS_TEXT = r.OLD_STATUS_TEXT,
                          .NEW_STATUS = r.NEW_STATUS,
                          .NEW_STATUS_TEXT = r.NEW_STATUS_TEXT,
                         .COMMENT = r.COMMENT,
                          .CREATE_DATE = r.CREATE_DATE,
                          .OPERATOR_ID = r.OPERATOR_ID}

        Session("EditSeqId") = id
        Session("OldStatus") = model.STATUS
        Return View(comment)
    End Function

    <HttpPost()> _
    Function Detail(ByVal id As String, ByVal collection As FormCollection) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing OrElse Not (acc.ROLE("Read") OrElse acc.ROLE("Write")) Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If collection("button") = "ステータス更新" Then ' ステータス更新ボタンを押したとき
            Session(ScreenDefine.sessionID_PID) = ScreenDefine.pageId_Home_StatusUpdate
            Return RedirectToAction("StatusUpdate", "Home")
        Else    ' 戻るボタンを押したとき
            Return RedirectToAction("List", "Home")
        End If
        Return View()
    End Function


    Function StatusUpdate() As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing OrElse Not acc.ROLE("Write") Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If Session(ScreenDefine.sessionID_PID) <> ScreenDefine.pageId_Home_StatusUpdate Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        ' セッションからStatusUpdateオブジェクトの取得
        Dim data As StatusUpdateData = TryCast(Session("StatusUpdateData"), StatusUpdateData)

        If data Is Nothing Then ' オブジェクトがないとき
            ViewData("seq_id") = Session("EditSeqId")

            ' ステータス情報の取得
            Dim items As List(Of SelectListItem) = New List(Of SelectListItem)()
            Util.AddListItem(items, "3")

            Dim status As SelectList

            ' 現在のステータス情報をセット
            If Session("SelectStatus") Is Nothing Then
                status = New SelectList(items, "Value", "Text", Session("OldStatus"))
            Else
                status = New SelectList(items, "Value", "Text", Session("SelectStatus"))
            End If

            ' 表示データのセット
            ViewData("status") = status
        Else    ' オブジェクトがあるとき
            ViewData("seq_id") = Session("EditSeqId")

            ' ステータス情報の取得
            Dim items As List(Of SelectListItem) = New List(Of SelectListItem)()
            Util.AddListItem(items, "3")

            Dim status As SelectList

            'ステータス情報のセット
            status = New SelectList(items, "Value", "Text", data.NEW_STATUS)

            ' 表示データのセット
            ViewData("status") = status
            ViewData("comment") = data.COMMNET

        End If

        Return View()
    End Function

    <HttpPost()> _
    Function StatusUpdate(ByVal collection As FormCollection) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing OrElse Not acc.ROLE("Write") Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If Session(ScreenDefine.sessionID_PID) <> ScreenDefine.pageId_Home_StatusUpdate Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If collection("button") = "戻る" Then ' 戻るボタンを押したとき
            Session("SelectStatus") = Nothing
            Session("StatusUpdateData") = Nothing
            Session(ScreenDefine.sessionID_PID) = Nothing
            Return RedirectToAction("Detail", "Home")
        Else ' 確認ボタンを押したとき
            Session("SelectStatus") = collection("status")

            ' バリデーション
            If collection.Item("comment") = "" Then
                ModelState.AddModelError("", "コメントは必須です")
            End If

            If collection.Item("comment").Length > 256 Then
                ModelState.AddModelError("", "コメントは２５６文字までです")
            End If

            If Util.IncludeSpecialCharacter(collection.Item("comment")) Then
                ModelState.AddModelError("", "コメントに機種依存文字は使えません")
            End If

            If Not ModelState.IsValid Then
                Return StatusUpdate()
            End If

            ' StatusUpdateオブジェクトに値をセット
            Dim data As StatusUpdateData = New StatusUpdateData
            data.SEQ_ID = Session("EditSeqId")
            data.OLD_STATUS = Session("OldStatus")
            data.NEW_STATUS = collection("status")
            data.COMMNET = collection("comment")

            Session("StatusUpdateData") = data
            Session(ScreenDefine.sessionID_PID) = ScreenDefine.pageId_Home_StatusUpdateConfirm
            Return RedirectToAction("StatusUpdateConfirm", "Home")
        End If
    End Function

    Function StatusUpdateConfirm() As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing OrElse Not acc.ROLE("Write") Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If Session(ScreenDefine.sessionID_PID) <> ScreenDefine.pageId_Home_StatusUpdateConfirm Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim data As StatusUpdateData = TryCast(Session("StatusUpdateData"), StatusUpdateData)

        ' 表示データをセット
        ViewData("seq_id") = data.SEQ_ID
        ViewData("old_status") = Util.GetDataName("3", data.OLD_STATUS)
        ViewData("new_status") = Util.GetDataName("3", data.NEW_STATUS)
        ViewData("comment") = data.COMMNET

        Return View()
    End Function

    <HttpPost()> _
    Function StatusUpdateConfirm(ByVal collection As FormCollection) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing OrElse Not acc.ROLE("Write") Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If Session(ScreenDefine.sessionID_PID) <> ScreenDefine.pageId_Home_StatusUpdateConfirm Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim data As StatusUpdateData = TryCast(Session("StatusUpdateData"), StatusUpdateData)

        If collection("button") = "戻る" Then ' 戻るボタンを押したとき
            Session(ScreenDefine.sessionID_PID) = ScreenDefine.pageId_Home_StatusUpdate
            Return RedirectToAction("StatusUpdate", "Home")
        Else ' 保存ボタンを押したとき  
            Dim connStr As String = Util.GetConnectionString
            Dim dc As WebFormDBDataContext = New WebFormDBDataContext(connStr)

            Using ts = New TransactionScope
                Try
                    ' ステータスの更新
                    dc.updateStatus(data.SEQ_ID, data.NEW_STATUS, Util.GetDataName("3", data.NEW_STATUS))

                    ' ステータスヒストリのインサート
                    dc.insertStatusHistory(data.SEQ_ID, data.OLD_STATUS, Util.GetDataName("3", data.OLD_STATUS), data.NEW_STATUS, Util.GetDataName("3", data.NEW_STATUS), data.COMMNET, acc.OPERATOR_ID)

                    dc.SubmitChanges()
                    ts.Complete()
                Catch ex As Exception
                    Return RedirectToAction("Maintenance", "Home")
                End Try
            End Using

            ' メッセージボックスの表示
            Session("MessageBoxTitle") = "ステータス更新完了"
            Session("MessageBoxMessage") = "ステータス更新が完了しました"

            Session("StatusUpdateData") = Nothing
            Session(ScreenDefine.sessionID_PID) = Nothing

            Return RedirectToAction("MessageBox", "Home")
        End If
    End Function

    Function MessageBox() As ActionResult
        ViewData("MessagaBoxTitle") = Session("MessageBoxTitle")
        ViewData("MessageBoxMessage") = Session("MessageBoxMessage")

        Return View()
    End Function

    <HttpPost()>
    Function MessageBox(ByVal collection As FormCollection) As ActionResult
        Session("MessageBoxTitle") = Nothing
        Session("MessageBoxMessage") = Nothing

        Return RedirectToAction("List", "Home")
    End Function

    Function Maintenance() As ActionResult
        Session.Clear()

        Return View()
    End Function

    Function About() As ActionResult
        Return View()
    End Function
End Class
