﻿Imports System.Data.Linq
Imports WebFormManager.Models

Namespace WebFormManager
    Public Class LogController
        Inherits System.Web.Mvc.Controller


        Function LogMain() As ActionResult
            Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

            If acc Is Nothing OrElse Not acc.ROLE("User Manager") Then
                Return RedirectToAction("Maintenance", "Home")
            End If

            Return View()
        End Function

        Function LoginLog() As ActionResult
            Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

            If acc Is Nothing OrElse Not acc.ROLE("User Manager") Then
                Return RedirectToAction("Maintenance", "Home")
            End If

            Return View()
        End Function

        <HttpPost()>
        Function LoginLog(ByVal collection As FormCollection) As ActionResult
            Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

            If acc Is Nothing OrElse Not acc.ROLE("User Manager") Then
                Return RedirectToAction("Maintenance", "Home")
            End If
            ' Trim
            collection("operator_id") = collection("operator_id").Trim
            collection("from_log_date") = collection("from_log_date").Trim
            collection("to_log_date") = collection("to_log_date").Trim
            '再表示
            ViewData("operator_id_value") = collection("operator_id")
            ViewData("from_log_date_value") = collection("from_log_date")
            ViewData("to_log_date_value") = collection("to_log_date")
            ' バリデーション
            If collection("operator_id") = "" AndAlso
                collection("from_log_date") = "" AndAlso
                collection("to_log_date") = "" Then
                ModelState.AddModelError("", "検索条件を入力してください")
            End If

            If (collection.Item("from_log_date") <> "" AndAlso collection.Item("to_log_date") = "") OrElse
                 (collection.Item("from_log_date") = "" AndAlso collection.Item("to_log_date") <> "") Then
                ModelState.AddModelError("", "開始日付と終了日付は両方とも入力してください")
            End If

            If collection.Item("from_log_date") <> "" AndAlso Not IsDate(collection.Item("from_log_date")) Then
                ModelState.AddModelError("", "開始日付は有効な日付(YYYY/MM/DD)で入力してください")
            End If

            If collection.Item("to_log_date") <> "" AndAlso Not IsDate(collection.Item("to_log_date")) Then
                ModelState.AddModelError("", "終了日付は有効な日付(YYYY/MM/DD)で入力してください")
            End If

            ' バリデーションエラーのとき
            If Not ModelState.IsValid Then
                Return LoginLog()
            End If

            Dim connStr As String = Util.GetConnectionString
            Dim dc As WebFormDBDataContext = New WebFormDBDataContext(connStr)
            Dim model As DBModelLoginLog = New DBModelLoginLog

            Dim from_date As DateTime = DateTime.MinValue
            If collection.Item("from_log_date") <> "" Then
                from_date = DateTime.Parse(collection.Item("from_log_date"))
            End If
            Dim to_date As DateTime = DateTime.MaxValue
            If collection.Item("to_log_date") <> "" Then
                to_date = DateTime.Parse(collection.Item("to_log_date")).AddDays(1)
            End If

            Dim page As Integer = If(Session("login_log_page"), 0)
            If collection("button") = "前頁" Then
                page = page - 1
            ElseIf collection("button") = "次頁" Then
                page = page + 1
            Else
                page = page
            End If
            Session("login_log_page") = page
            Dim MaxItem As Integer = CInt(Util.GetAppSetting("PageSizeLoginLogList"))
            Dim curPage As Integer = page
            Dim max As Integer = 0
            Try
                ' データを読み込む
                max = (From r In dc.GetTable(Of LoginLog)() Select r
                                      Where (collection.Item("operator_id") = "" OrElse r.OPERATOR_ID.Contains(collection.Item("operator_id"))) AndAlso
                                       (collection.Item("from_log_date") = "" OrElse r.LOGIN_DATE >= from_date) AndAlso
                                        (collection.Item("to_log_date") = "" OrElse r.LOGIN_DATE <= to_date)).Count

                model.LoginLog = (From r In dc.GetTable(Of LoginLog)() Select r
                           Where (collection.Item("operator_id") = "" OrElse r.OPERATOR_ID.Contains(collection.Item("operator_id"))) AndAlso
                            (collection.Item("from_log_date") = "" OrElse r.LOGIN_DATE >= from_date) AndAlso
                             (collection.Item("to_log_date") = "" OrElse r.LOGIN_DATE <= to_date) Order By r.LOGIN_DATE Descending).Skip(curPage * MaxItem).Take(MaxItem)

            Catch ex As Exception
                Return RedirectToAction("Meintenance", "Home")
            End Try
           
            model.CurrentPage = curPage
            ' 前頁があるとき
            If curPage = 0 Then
                model.HasPrevPage = False
            Else
                model.HasPrevPage = True
            End If
            ' 次頁があるとき
            If curPage * MaxItem + MaxItem < max Then
                model.HasNextPage = True
            Else
                model.HasNextPage = False
            End If


            Return View(model)
        End Function

        Function DownloadLog() As ActionResult
            Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

            If acc Is Nothing OrElse Not acc.ROLE("User Manager") Then
                Return RedirectToAction("Maintenance", "Home")
            End If

            Return View()
        End Function

        <HttpPost()>
        Function DownloadLog(ByVal collection As FormCollection) As ActionResult
            Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

            If acc Is Nothing OrElse Not acc.ROLE("User Manager") Then
                Return RedirectToAction("Maintenance", "Home")
            End If

            ' Trim
            collection("operator_id") = collection("operator_id").Trim
            collection("from_log_date") = collection("from_log_date").Trim
            collection("to_log_date") = collection("to_log_date").Trim

            ' 再表示
            ViewData("operator_id_value") = collection("operator_id")
            ViewData("from_log_date_value") = collection("from_log_date")
            ViewData("to_log_date_value") = collection("to_log_date")

            ' バリデーション
            If collection("operator_id") = "" AndAlso
                collection("from_log_date") = "" AndAlso
                collection("to_log_date") = "" Then
                ModelState.AddModelError("", "検索条件を入力してください")
            End If

            If (collection.Item("from_log_date") <> "" AndAlso collection.Item("to_log_date") = "") OrElse
                 (collection.Item("from_log_date") = "" AndAlso collection.Item("to_log_date") <> "") Then
                ModelState.AddModelError("", "開始日付と終了日付は両方とも入力してください")
            End If

            If collection.Item("from_log_date") <> "" AndAlso Not IsDate(collection.Item("from_log_date")) Then
                ModelState.AddModelError("", "開始日付は有効な日付(YYYY/MM/DD)で入力してください")
            End If

            If collection.Item("to_log_date") <> "" AndAlso Not IsDate(collection.Item("to_log_date")) Then
                ModelState.AddModelError("", "終了日付は有効な日付(YYYY/MM/DD)で入力してください")
            End If

            ' バリデーションエラーのとき
            If Not ModelState.IsValid Then
                Return LoginLog()
            End If

            Dim connStr As String = Util.GetConnectionString
            Dim dc As WebFormDBDataContext = New WebFormDBDataContext(connStr)
            Dim model As DBModelDownloadLog = New DBModelDownloadLog

            Dim from_date As DateTime = DateTime.MinValue
            If collection.Item("from_log_date") <> "" Then
                from_date = DateTime.Parse(collection.Item("from_log_date"))
            End If
            Dim to_date As DateTime = DateTime.MaxValue
            If collection.Item("to_log_date") <> "" Then
                to_date = DateTime.Parse(collection.Item("to_log_date")).AddDays(1)
            End If

            Dim page As Integer = If(Session("download_log_page"), 0)
            If collection("button") = "前頁" Then
                page = page - 1
            ElseIf collection("button") = "次頁" Then
                page = page + 1
            Else
                page = page
            End If
            Session("download_log_page") = page
            Dim MaxItem As Integer = CInt(Util.GetAppSetting("PageSizeDownloadLogList"))
            Dim curPage As Integer = page
            Dim max As Integer = 0
            Try
                ' データを読み込む
                max = (From r In dc.GetTable(Of DownloadLog)() Select r
                           Where (collection.Item("operator_id") = "" OrElse r.OPERATOR_ID.Contains(collection.Item("operator_id"))) AndAlso
                            (collection.Item("from_log_date") = "" OrElse r.DOWNLOAD_DATE >= from_date) AndAlso
                             (collection.Item("to_log_date") = "" OrElse r.DOWNLOAD_DATE <= to_date)).Count

                model.DownloadLog = (From r In dc.GetTable(Of DownloadLog)() Select r
                           Where (collection.Item("operator_id") = "" OrElse r.OPERATOR_ID.Contains(collection.Item("operator_id"))) AndAlso
                            (collection.Item("from_log_date") = "" OrElse r.DOWNLOAD_DATE >= from_date) AndAlso
                             (collection.Item("to_log_date") = "" OrElse r.DOWNLOAD_DATE <= to_date) Order By r.DOWNLOAD_DATE Descending).Skip(curPage * MaxItem).Take(MaxItem)
            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try
            model.CurrentPage = curPage
            ' 前頁があるとき
            If curPage = 0 Then
                model.HasPrevPage = False
            Else
                model.HasPrevPage = True
            End If
            '　次頁があるとき
            If curPage * MaxItem + MaxItem < max Then
                model.HasNextPage = True
            Else
                model.HasNextPage = False
            End If
            Return View(model)
        End Function

    End Class
End Namespace