﻿<%@ Page Title="" Language="VB" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage(Of WebFormManager.Models.DBModelRequestData)" %>
<%@ Import Namespace="WebFormManager.Models" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
	一覧
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <script type="text/javascript">
        function searchConditionClear() {
            document.getElementById("seq_id").value = "";
            document.getElementById("kanji_sei").value = "";
            document.getElementById("kanji_mei").value = "";
            document.getElementById("kana_sei").value = "";
            document.getElementById("kana_mei").value = "";
            document.getElementById("zip").value = "";
            document.getElementById("email").value = "";
            document.getElementById("from_date").value = "";
            document.getElementById("to_date").value = "";
        }
    </script>
    <h2>一覧</h2>
    <p>
        <%= Html.ValidationSummary%>
    </p>
    <% Using Html.BeginForm()%>
    <p>検索条件を入力してください</p>
    <table>
        <tr>
            <td>申込番号<%= Html.TextBox("seq_id", ViewData("seq_id_value"), New With {.maxlength = "10"})%></td>
        </tr>
        <tr>
            <td>姓（漢字）<%= Html.TextBox("kanji_sei", ViewData("kanji_sei_value"), New With {.maxlength = "20"})%>
            名（漢字）<%= Html.TextBox("kanji_mei", ViewData("kanji_mei_value"), New With {.maxlength = "20"})%></td>
        </tr>
         <tr>
            <td>姓（カナ）<%= Html.TextBox("kana_sei", ViewData("kana_sei_value"), New With {.maxlength = "20"})%>
            名（カナ）<%= Html.TextBox("kana_mei", ViewData("kana_mei_value"), New With {.maxlength = "40"})%></td> 
        </tr>
         <tr>
            <td>郵便番号<%= Html.TextBox("zip", ViewData("zip_value"), New With {.maxlength = "10"})%>(#######形式)
            メールアドレス<%= Html.TextBox("email", ViewData("email_value"), New With {.maxlength = "50"})%>
            </td>
         </tr>
        <tr>
            <td>日付<%= Html.TextBox("from_date", ViewData("from_date_value"), New With {.maxlength = "10"})%>
            ～<%= Html.TextBox("to_date", ViewData("to_date_value"), New With {.maxlength = "10"})%>
            (YYYY/MM/DD形式)
            </td>
        </tr>
   </table>
    <input type="submit" name="button" value="検索" />
    <input type="button" name="button" value="検索条件のクリア" onclick="searchConditionClear(); return false;"/>
   
    <hr />
    <table>
        <tr>
            <th></th>
            <th>SEQ_ID</th>
            <th>名前（漢字）</th>
            <th>名前（カナ）</th>
            <th>生年月日</th>
            <th>性別</th>
            <th>郵便番号</th>
            <th>住所</th>
            <th>自宅電話番号</th> 
            <th>携帯電話番号</th>
            <th>メールアドレス</th>
            <th>職業</th>
            <th>申込日付</th>
            <th>ステータス</th>
            <th>IPアドレス</th>
            <th>セッションID</th>
        </tr>
        <%If Not Model Is Nothing Then%>
        <% For Each item In Model.RequestData%>
        <tr>
            <td><%= Html.ActionLink("編集", "Detail", New With {.id = item.SEQ_ID})%></td>
            <td><%= item.SEQ_ID%></td>
            <td><%= item.SEI_KANJI%> <%= item.MEI_KANJI%></td>
            <td><%= item.SEI_KANA%> <%= item.MEI_KANA%></td>
            <td><%= String.Format("{0:0000}/{1:00}/{2:00}", item.BIRTH_DATE.Substring(0, 4), item.BIRTH_DATE.Substring(4, 2), item.BIRTH_DATE.Substring(6, 2))%></td>
            <td><%= item.GENDER_TEXT%></td>
            <td><%= item.ZIP1%>-<%= item.ZIP2%></td>
            <td><%= item.ADDRESS1%><%= item.ADDRESS2%><%= item.ADDRESS3%><%= item.ADDRESS4%></td>
            <td><%= item.TEL1%>-<%= item.TEL2%>-<%= item.TEL3%></td>
            <td><%= item.M_TEL1%>-<%= item.M_TEL2%>-<%= item.M_TEL3%></td>
            <td><%= item.E_MAIL%></td>
            <td><%= item.OCCUPATION_TEXT%></td>
            <td><%= item.REQUEST_DATE.ToString("yyyy/MM/dd HH:mm:ss")%></td>
            <td><%= item.STATUS_TEXT%></td>
            <td><%= item.IP_ADDRESS%></td>
            <td><%= item.SESSION_ID%></td>
        </tr>
        <% Next%>
        <%End If%>
    </table>
    <%If Not Model Is Nothing Then%>
    <%If Model.HasPrevPage Then %>
        <input type="submit" name="button" value="前頁" />
    <%Else%>
        前頁
    <%End If%>
    <%If Model.HasNextPage Then%>
        <input type="submit" name="button" value="次頁" />
    <%Else%>
        次頁
    <%End If%>
    <% End If%>
     <% End Using%>
</asp:Content>
