﻿<%@ Page Title="" Language="VB" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage(Of WebFormManager.Models.DBModelDownloadLog)" %>
<%@ Import Namespace="WebFormManager.Models" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
	ダウンロードログ
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <h2>ダウンロードログ</h2>
    <p>
        <%= Html.ValidationSummary%>
    </p>
    <% Using Html.BeginForm()%>
        オペレータID：<%= Html.TextBox("operator_id", ViewData("operator_id_value"), New With {.maxlength = "20"})%><br />
        ログ日付：<%= Html.TextBox("from_log_date", ViewData("from_log_date_value"), New With {.maxlength = "10"})%>～<%= Html.TextBox("to_log_date", ViewData("to_log_date_value"), New With {.maxlength = "10"})%>
        <input type="submit" name="button" value="検索" />
    

    <table>
        <tr>
            <th>オペレータID</th>
            <th>ダウンロードファイル名</th>
            <th>データ数</th>
            <th>ダウンロード日時</th>
            <th>IPアドレス</th>
            <th>セッションID</th>
        </tr>
        <%If Not Model Is Nothing Then%>
        <% For Each item In Model.DownloadLog%>
        <tr>
            <td><%=item.OPERATOR_ID%></td>
            <td><%=item.DOWNLOAD_FILENAME%></td>
            <td><%=item.DOWNLOAD_COUNT%></td>
            <td><%=item.DOWNLOAD_DATE.ToString("yyyy/MM/dd HH:mm:ss")%></td>
            <td><%=item.IP_ADDRESS%></td>
            <td><%=item.SESSION_ID%></td>
        </tr>
        <% Next%>
        <%End If%>
    </table>
     <%If Not Model Is Nothing Then%>
    <%If Model.HasPrevPage Then %>
        <input type="submit" name="button" value="前頁" />
    <%Else%>
        前頁
    <%End If%>
    <%If Model.HasNextPage Then%>
        <input type="submit" name="button" value="次頁" />
    <%Else%>
        次頁
    <%End If%>
    <% End If%>  
    <% End Using%>
</asp:Content>
